theory question_45_1

imports Main

begin
typedecl entity
typedecl event

consts
  Woman :: "entity ⇒ bool"
  Running :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  BlackClothing :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Bicycles :: "entity ⇒ bool"
  FemaleRunner :: "entity ⇒ bool"
  Barefoot :: "entity ⇒ bool"
  Runs :: "event ⇒ bool"
  Down :: "event ⇒ entity ⇒ bool"
  NextTo :: "entity ⇒ entity ⇒ bool"
  Two :: "entity ⇒ bool"

(* Explanation 1: A woman running is outdoors. *)
axiomatization where
  explanation_1: "∃x e. Woman x ∧ Running e ∧ Agent e x ⟶ Outdoors x"

theorem hypothesis:
  (* Premise: A woman in black clothing runs down the street barefoot next to two people on bicycles and a female runner. *)
  assumes asm: "Woman x ∧ BlackClothing x ∧ Street y ∧ People z ∧ Bicycles w ∧ FemaleRunner v ∧ Barefoot x ∧ Runs e ∧ Agent e x ∧ Down e y ∧ NextTo x z ∧ NextTo x v ∧ Two z"
  (* Hypothesis: The woman is outdoors. *)
  shows "∃x. Woman x ∧ Outdoors x"
proof -
  from asm have "Woman x ∧ Runs e ∧ Agent e x" by blast
  then have "Outdoors x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
