theory question_1_0

imports Main

begin
typedecl entity

consts
  YoungBoy :: "entity ⇒ bool"
  CrowdedPatio :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Patio :: "entity ⇒ bool"
  CrowdedWith :: "entity ⇒ entity ⇒ bool"
  MetalTables :: "entity ⇒ bool"
  Chairs :: "entity ⇒ bool"
  YellowUmbrellas :: "entity ⇒ bool"
  PatioCrowdedWithMetalTables :: "entity ⇒ bool"
  Paraphrase :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: On a crowded patio is a paraphrase of on a patio crowded with metal tables. *)
axiomatization where
  explanation_1: "∀x y. CrowdedPatio x ∧ PatioCrowdedWithMetalTables y ⟶ Paraphrase x y"

theorem hypothesis:
  (* Premise: A young boy is on a patio crowded with metal tables and chairs and 2 yellow umbrellas. *)
  assumes asm: "YoungBoy x ∧ Patio y ∧ CrowdedWith y z ∧ MetalTables z ∧ Chairs u ∧ YellowUmbrellas v ∧ On x y"
  (* Hypothesis: A young boy is on a crowded patio. *)
  shows "∃x y. YoungBoy x ∧ CrowdedPatio y ∧ On x y"
proof -
  from asm have "YoungBoy x ∧ Patio y ∧ On x y" by blast
  then have "YoungBoy x ∧ CrowdedPatio y ∧ On x y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
