theory question_86_0
imports Main

begin

typedecl entity
typedecl event

consts
  Snow :: "entity ⇒ bool"
  Ice :: "entity ⇒ bool"
  Water :: "entity ⇒ bool"
  SolidState :: "entity ⇒ bool"
  TemperaturesBetween :: "entity ⇒ bool"
  Freezing :: "event ⇒ bool"
  Liquid :: "entity ⇒ bool"
  Solid :: "entity ⇒ bool"
  HeatEnergy :: "entity ⇒ bool"
  Changing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Reducing :: "event ⇒ entity ⇒ bool"
  FreezingPoint :: "entity ⇒ bool"
  Temperature :: "entity ⇒ bool"
  LiquidFreezes :: "entity ⇒ entity ⇒ bool"
  BelowWhich :: "entity ⇒ entity ⇒ bool"
  State :: "entity ⇒ bool"
  Form :: "entity ⇒ bool"

(* Explanation 1: snow is a kind of ice. *)
axiomatization where
  explanation_1: "∀x. Snow x ⟶ Ice x"

(* Explanation 2: water is in the solid state, called ice, for temperatures between 0; -459; -273 and 273; 32; 0. *)
axiomatization where
  explanation_2: "∀x y. Water x ∧ Ice y ∧ SolidState x ∧ TemperaturesBetween y ∧ 0 x ∧ -459 x ∧ -273 x ∧ 273 x ∧ 32 x ∧ 0 x"

(* Explanation 3: water is a kind of liquid. *)
axiomatization where
  explanation_3: "∀x. Water x ⟶ Liquid x"

(* Explanation 4: freezing means changing from a liquid into a solid by reducing heat energy. *)
axiomatization where
  explanation_4: "∀e x y z. Freezing e ∧ Liquid x ∧ Solid y ∧ HeatEnergy z ∧ Changing e ∧ Agent e x ∧ Patient e y ∧ Reducing e z"

(* Explanation 5: freezing point means temperature at which a liquid freezes; below which a liquid freezes. *)
axiomatization where
  explanation_5: "∀x y. FreezingPoint x ∧ Temperature y ∧ LiquidFreezes x y ∧ BelowWhich x y"

(* Explanation 6: state means form. *)
axiomatization where
  explanation_6: "∀x y. State x ∧ Form y"

theorem hypothesis:
  assumes asm: "Water x ∧ Temperature y ∧ BelowWhich y z ∧ SolidState z"
  (* Hypothesis: Snow is the form of water that appears when the temperature is below freezing. *)
  shows "∃x y z e. Snow x ∧ Water y ∧ Temperature z ∧ BelowWhich z e ∧ SolidState e ∧ Form x"
proof -
  from asm obtain y z where yz: "Water x ∧ Ice y ∧ SolidState z ∧ TemperaturesBetween z ∧ 0 z ∧ -459 z ∧ -273 z ∧ 273 z ∧ 32 z ∧ 0 z" using explanation_2 by blast
  then have "Snow x" using explanation_1 by blast
  then have "Form x" using explanation_6 by blast
  have conclusion: "Water x ∧ Temperature y ∧ BelowWhich y z ∧ SolidState z" using asm by simp
  show ?thesis using conclusion yz `Form x` by blast
qed

end
