theory question_66_7
imports Main
begin

typedecl entity
typedecl event

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  Stars :: "entity ⇒ bool"
  Hottest :: "entity ⇒ entity ⇒ entity ⇒ entity ⇒ bool"
  Hotter :: "entity ⇒ entity ⇒ bool"
  Earth :: "entity ⇒ bool"
  Mars :: "entity ⇒ bool"
  Moon :: "entity ⇒ bool"

(* Explanation 1: The Sun is a kind of star. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ Star x"

(* Explanation 2: The Sun is the hottest among stars. *)
axiomatization where
  explanation_2: "∀x y. Sun x ∧ Stars y ⟶ (∃z w. Hottest x y z w)"

(* Explanation 3: The Sun being the hottest among objects implies it is hotter than the Earth, Mars, and the Moon. *)
axiomatization where
  explanation_3: "∀x y z w. Sun x ∧ Hottest x y z w ⟶ Hotter x y ∧ Hotter x z ∧ Hotter x w"

theorem hypothesis:
  assumes asm: "Sun x ∧ Earth y ∧ Mars z ∧ Moon w"
  (* Hypothesis: The Sun is the hottest among the Earth, Mars, and the Moon. *)
  shows "Hottest x y z w"
proof -
  from asm have "Sun x" by simp
  then have "Star x" using explanation_1 by blast
  then obtain y z where yz: "Stars y ∧ Hottest x y z w" using explanation_2 by blast
  then have "Hotter x y" "Hotter x z" "Hotter x w" using explanation_3 by blast
  then show ?thesis using yz by blast
qed

end
