theory question_60_0
imports Main
begin

typedecl entity
typedecl event

consts
  PhaseChange :: "event ⇒ bool"
  Mass :: "entity ⇒ bool"
  Change :: "event ⇒ entity ⇒ bool"
  Melting :: "event ⇒ bool"
  Solid :: "entity ⇒ bool"
  Liquid :: "entity ⇒ bool"
  HeatEnergy :: "entity ⇒ bool"
  Agent :: "event ⇒ event ⇒ bool"
  Property :: "entity ⇒ bool"
  Matter :: "entity ⇒ bool"
  Objects :: "entity ⇒ bool"
  Materials :: "entity ⇒ bool"
  Ice :: "entity ⇒ bool"
  Beaker :: "entity ⇒ bool"
  Volume :: "entity ⇒ int ⇒ bool"
  Placed :: "event ⇒ bool"
  Container :: "event ⇒ entity ⇒ bool"
  Content :: "event ⇒ entity ⇒ bool"
  Location :: "event ⇒ entity ⇒ bool"
  TimePeriod :: "event ⇒ bool"
  Several :: "event ⇒ bool"
  Hours :: "event ⇒ bool"
  Time :: "event ⇒ event ⇒ bool"

(* Explanation 1: phase changes do not change mass. *)
axiomatization where
  explanation_1: "∀e. PhaseChange e ⟶ ¬(∃x. Mass x ∧ Change e x)"

(* Explanation 2: melting means changing from a solid into a liquid by adding heat energy. *)
axiomatization where
  explanation_2: "∀e1 e2. Melting e1 ⟷ (Change e2 e1 ∧ Solid e2 ∧ Liquid e2 ∧ HeatEnergy e2 ∧ Agent e2 e1)"

(* Explanation 3: melting is a kind of phase change. *)
axiomatization where
  explanation_3: "Melting ⟶ PhaseChange"

(* Explanation 4: mass; weight is a property of matter; objects; materials. *)
axiomatization where
  explanation_4: "∀x. Mass x ⟶ Property x ∧ Matter x ∧ Objects x ∧ Materials x"

theorem hypothesis:
  (* Premise: a beaker containing 50 milliliters of ice is placed on a windowsill. *)
  assumes asm: "Beaker x ∧ Ice y ∧ Volume y 50 ∧ Placed e ∧ Container e x ∧ Content e y ∧ Location e Windowsill"
  (* Hypothesis: The mass of the ice did not change when it melted. *)
  shows "∃e. Ice e ∧ Melting e ∧ ¬ Mass x ∧ Change e x "
proof -
  from asm have "Ice y" by simp
  then obtain e where e: "Change e y ∧ Solid y ∧ Liquid y ∧ HeatEnergy y ∧ Agent y e" using explanation_2 by blast
  then have "PhaseChange e" using explanation_3 by blast
  then have "¬ Mass x" using explanation_1 e by blast
  have conclusion: "Change e y ∧ Solid y ∧ Liquid y ∧ HeatEnergy y ∧ Agent y e" using e by simp
  show ?thesis using conclusion `¬ Mass x` by blast
qed

end
