theory question_25_0

imports Main

begin

typedecl entity
typedecl event

consts
  Mouse :: "entity ⇒ bool"
  MeadowEcosystem :: "entity ⇒ bool"
  Plants :: "entity ⇒ bool"
  Receive :: "event ⇒ bool"
  DirectlyFrom :: "event ⇒ entity ⇒ bool"
  Energy :: "entity ⇒ bool"
  NeedToSurvive :: "entity ⇒ entity ⇒ bool"
  Survive :: "entity ⇒ bool"

(* Explanation 1: a mouse is a kind of animal. *)
axiomatization where
  explanation_1: "∀x. Mouse x ⟶ Animal x"

(* Explanation 11: a mouse is a kind of herbivore. *)
axiomatization where
  explanation_11: "∀x. Mouse x ⟶ Herbivore x"

theorem hypothesis:
  assumes asm: "MeadowEcosystem x ∧ Mouse y ∧ Plants z"
  (* Hypothesis: In a meadow ecosystem, mice receive most of the energy they need to survive directly from plants. *)
  shows "∃x y z e. MeadowEcosystem x ∧ Mouse y ∧ Plants z ∧ Receive e ∧ DirectlyFrom e z ∧ Energy z ∧ NeedToSurvive y z ∧ Survive y"
proof -
  from asm obtain e where e: "Receive e ∧ DirectlyFrom e z ∧ Energy z ∧ NeedToSurvive y z" by blast
  then have "Survive y" using e by blast
  show ?thesis using asm e `Survive y` by blast
qed

end
