theory question_11_0
imports Main

begin

typedecl entity
typedecl event

consts
  ElectricalConductor :: "entity ⇒ bool"
  Outlet :: "entity ⇒ bool"
  Plugged :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Circuit :: "entity ⇒ bool"
  Completed :: "event ⇒ bool"
  Complete :: "entity ⇒ bool"
  ElectricalCircuit :: "entity ⇒ bool"
  Is :: "event ⇒ bool"
  Source :: "event ⇒ bool"
  Electricity :: "entity ⇒ bool"
  ElectricalEnergy :: "entity ⇒ bool"
  Safe :: "entity ⇒ bool"
  Harm :: "entity ⇒ bool"
  Danger :: "entity ⇒ bool"
  Appliances :: "entity ⇒ bool"
  Many :: "entity ⇒ bool"
  One :: "entity ⇒ bool"
  Plugging :: "event ⇒ bool"
  Dangerous :: "entity ⇒ bool"
  InDanger :: "entity ⇒ bool"
  Around :: "entity ⇒ entity ⇒ bool"
  Near :: "entity ⇒ entity ⇒ bool"
  Electrocution :: "entity ⇒ bool"
  Organism :: "entity ⇒ bool"
  Causes :: "event ⇒ bool"
  Electrocuted :: "event ⇒ bool"

(* Explanation 1: when an electrical conductor is plugged into an outlet, a circuit is completed. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. ElectricalConductor x ∧ Outlet y ∧ Plugged e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Circuit z ∧ Completed e2 ∧ Agent e2 z ∧ Patient e2 x"

(* Explanation 2: a complete electrical circuit is a source of electrical energy. *)
axiomatization where
  explanation_2: "∀x y e. Complete x ∧ ElectricalCircuit y ∧ Is e ∧ Source e ∧ Agent e y ∧ Patient e x"

(* Explanation 3: electricity means electrical energy. *)
axiomatization where
  explanation_3: "∀x y. Electricity x ⟶ ElectricalEnergy x"

(* Explanation 4: safe is the opposite of harm; danger. *)
axiomatization where
  explanation_4: "∀x y z. Safe x ⟷ (¬Harm y ∧ Danger z)"

(* Explanation 5: plugging many appliances into one outlet is dangerous. *)
axiomatization where
  explanation_5: "∀x y e. Appliances x ∧ Outlet y ∧ Many x ∧ One y ∧ Plugging e ∧ Agent e x ∧ Patient e y ⟶ Dangerous e"

(* Explanation 6: to be in danger means to be around; to be near something dangerous. *)
axiomatization where
  explanation_6: "∀x y z. InDanger x ⟷ (Around x y ∧ Near x z ∧ Dangerous z)"

(* Explanation 7: electrocution causes harm to an organism. *)
axiomatization where
  explanation_7: "∀x y e. Electrocution x ∧ Organism y ⟶ (∃e. Causes e ∧ Agent e x ∧ Patient e y)"

(* Explanation 8: if electricity flows through; is transferred through the body of an animal then that animal is electrocuted. *)
axiomatization where
  explanation_8: "∀x y z e1 e2 e3. Electricity x ∧ Flows e1 ∧ Transferred e2 ∧ Body z ∧ Animal y ∧ Is e3 ∧ Agent e1 x ∧ Patient e1 z ∧ Agent e2 x ∧ Patient e2 z ⟶ (∃e. Electrocuted e ∧ Agent e y ∧ Patient e z)"

(* Explanation 9: an animal is a kind of organism. *)
axiomatization where
  explanation_9: "∀x. Animal x ⟶ Organism x"

theorem hypothesis:
  assumes asm: "Appliances x ∧ Outlet y"
  (* Hypothesis: Plugging many appliances into one outlet is not a way to stay safe around electricity. *)
  shows "∃x y e. Appliances x ∧ Outlet y ∧ Many x ∧ One y ∧ Plugging e ∧ Agent e x ∧ Patient e y ∧ ¬ Safe z ∧ Around z Electricity "
proof -
  from asm have "Appliances x ∧ Outlet y" by simp
  then obtain e where e: "Many x ∧ One y ∧ Plugging e ∧ Agent e x ∧ Patient e y" using explanation_5 by blast
  then have "Dangerous e" using explanation_5 by blast
  then obtain z where z: "Around z Electricity" using explanation_6 by blast
  have conclusion: "Many x ∧ One y ∧ Plugging e ∧ Agent e x ∧ Patient e y ∧ Dangerous e ∧ Around z Electricity" using e z by simp
  show ?thesis using conclusion by blast
qed

end
