theory question_81_6
imports Main
begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Trigger :: "event ⇒ event ⇒ bool"
  Occur :: "event ⇒ bool"
  Lead :: "event ⇒ event ⇒ bool"

(* Explanation 1: External migration can trigger the bottleneck effect. *)
axiomatization where
  explanation_1: "∀e x. ExternalMigration x ⟶ (∃e1. BottleneckEffect e1 ∧ Trigger e e1)"

(* Explanation 2: When the bottleneck effect is triggered, it occurs as a result. *)
axiomatization where
  explanation_2: "∀e1 e2 x. BottleneckEffect x ∧ Trigger e1 x ⟶ Occur e2"

(* Explanation 3: If the bottleneck effect is triggered, it leads to its occurrence. *)
axiomatization where
  explanation_3: "∀e1 e2 x. BottleneckEffect x ∧ Trigger e1 x ⟶ (Lead e2 e1 ∧ Occur e2)"

(* Explanation 4: Therefore, external migration can lead to the occurrence of the bottleneck effect. *)
axiomatization where
  explanation_4: "∀e x. ExternalMigration x ⟶ (∃e1. BottleneckEffect e1 ∧ Lead e e1 ∧ Occur e)"

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration e"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e x. BottleneckEffect x ∧ ExternalMigration e ∧ Occur e"
proof -
  from asm have "BottleneckEffect x" using asm by simp
  then obtain e1 where e1: "Lead e e1 ∧ Occur e" using explanation_4 by blast
  then have "ExternalMigration e" using explanation_1 by blast
  have conclusion: "Lead e e1 ∧ Occur e" using e1 by simp
  show ?thesis using conclusion `ExternalMigration e` `BottleneckEffect x` by blast
qed

end
