theory question_21_0
imports Main

begin

typedecl entity
typedecl event

consts
  ClassAves :: "entity ⇒ bool"
  Birds :: "entity ⇒ bool"
  EndothermicTetrapodVertebrate :: "entity ⇒ bool"
  Be :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Class Aves is for the birds, literally. *)
axiomatization where
  explanation_1: "∀x. ClassAves x ⟶ Birds x"

theorem hypothesis:
  assumes asm: ""
  (* Hypothesis: An endothermic tetrapod vertebrate would be animals in the class aves. *)
  shows "∃x. EndothermicTetrapodVertebrate x ∧  ∀e. Be e ∧ Agent e x  ∧ ClassAves x "
proof -
  have "∀x. Birds x ⟶ EndothermicTetrapodVertebrate x" using explanation_1 by blast
  then have "∀x. ClassAves x ⟶ EndothermicTetrapodVertebrate x" using explanation_1 by blast
  then have "∀x. ClassAves x ⟶ Birds x" using explanation_1 by blast
  then have "∀x. ClassAves x ⟶ EndothermicTetrapodVertebrate x ∧ Birds x" by blast
  then obtain x where x: "EndothermicTetrapodVertebrate x ∧ Birds x" by blast
  then have "ClassAves x" using explanation_1 by blast
  then have "EndothermicTetrapodVertebrate x ∧  ∀e. Be e ∧ Agent e x  ∧ ClassAves x" using x by blast
  then show ?thesis by blast
qed

end
