theory question_85_2

imports Main

begin
typedecl entity
typedecl event

consts
  Vendors :: "entity ⇒ bool"
  Flowers :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  Sell :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  FlowerCart :: "entity ⇒ bool"

(* Explanation 1: Vendors who sell flowers on the sidewalk are flower sellers on the sidewalk. *)
axiomatization where
  explanation_1: "∀x y e. Vendors x ∧ Flowers y ∧ Sidewalk z ∧ Sell e ∧ Agent e x ∧ Patient e y ∧ On x z ∧ FlowerSeller x ∧ On x z"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "Sidewalk x ∧ FlowerCart y ∧ Vendor x ∧ On y x"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x y e. FlowerSeller x ∧ Sidewalk y ∧ On x y ∧ Sell e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Vendor x ∧ Sidewalk x" by blast
  then have "FlowerSeller x ∧ Sidewalk x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
