# Explanation of DATA File Structure

The DATA file (data.json) contains an object where each key represents an index (starting from "0") and maps to another object containing url, annotation, and bounding box. The structure of the JSON is as follows:

```json
{
  "0": {
    "url": "url",
    "visual_premises": [], //list of visual premises
    "commonsense_premises": [], //list of commonsense premises
    "conclusion": "", //conclusion of the visual argument
    "reasoning_steps": [], //list of reasoning trees
    "b_box": [ //list of bounding boxes
      {
        "startX": 0,
        "startY": 0,
        "w": 0,
        "h": 0
      }
    ]
  }
}


# Explanation of TASK File Structure
The Tas file (task_2_data.json) contains data for task 2.

```json
{
  "./dataset/images/example.jpg": [
{
      "easy_answer": 0,
      "hard_clip_answer": 0,
      "hard_colbert_answer": 0,
      "hard_colbert_clip_answer": 0,
      "hard_semantic_answer": 0,
      "easy_vp_options": [
      ],
      "hard_clip_vp_options": [
      ],
      "hard_colbert_vp_options": [
      ],
      "hard_colbert_clip_vp_options": [
      ],
      "hard_semantic_vp_options": [
      ],
      "description": ""
    }
  ]
}
