#!/usr/bin/env bash
echo "------------------------------------ scratch -------------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VILBERT_VQA_fullvocab/temperature_pth_512_1024/answer_sampling/50000_ep" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.01 -lr 0.00005 -word_emb_size 128 -hidden_size 256 -num_episodes_train 50000 -debug "0,20000" -lm_path "output/vqa_lm_model/model.pt" -num_episodes_test 2000 -mask_answers 1 -grad_clip 5 -fusion "average" -condition_answer "after_fusion" -device_id 1 -s_min 1 -entropy_coeff 0.01 -reward "vilbert_rank2" -reward_vocab "output/vilbert_vqav2/bert_base_6layer_6conect.json" -reward_path "output/vilbert_vqav2/model.bin" -test_metrics "return" "dialog" "bleu" "ppl_dialog_lm" "ttr_question" "sum_probs" "ppl" "lv_norm" "ttr" "selfbleu" "dialogimage" "language_score" "size_valid_actions" -answer_sampl "img_sampling"
echo "------------------------------------proba thr + temp sch. - fusion average -------------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VILBERT_VQA_fullvocab/temperature_pth_512_1024/answer_sampling/50000_ep" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.01 -lr 0.00005 -word_emb_size 128 -hidden_size 256 -num_episodes_train 100000 -debug "0,20000" -lm_path "output/vqa_lm_model/model.pt" -num_episodes_test 2000 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 5 -fusion "average" -condition_answer "after_fusion" -device_id 0 -temperature 1.5 -temp_step 5000 -temp_factor 0.75 -temp_min 1 -p_th 0.005 -s_min 1 -entropy_coeff 0.01 -reward "vilbert_rank2" -reward_vocab "output/vilbert_vqav2/bert_base_6layer_6conect.json" -reward_path "output/vilbert_vqav2/model.bin" -test_metrics "return" "dialog" "bleu" "ppl_dialog_lm" "ttr_question" "sum_probs" "ppl" "lv_norm" "ttr" "selfbleu" "dialogimage" "language_score" "size_valid_actions" -answer_sampl "img_sampling"
echo "------------------------------------proba thr(0.005) + temp sch. - fusion average - GPT-2 -------------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VILBERT_VQA_fullvocab/temperature_pth_512_1024/answer_sampling/50000_ep" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.01 -lr 0.00005 -word_emb_size 128 -hidden_size 256 -num_episodes_train 100000 -debug "0,20000" -lm_path "gpt" -num_episodes_test 2000 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 5 -fusion "average" -condition_answer "after_fusion" -device_id 1 -temperature 1.5 -temp_step 5000 -temp_factor 0.75 -temp_min 1 -p_th 0.005 -s_min 1 -entropy_coeff 0.01 -reward "vilbert_rank2" -reward_vocab "output/vilbert_vqav2/bert_base_6layer_6conect.json" -reward_path "output/vilbert_vqav2/model.bin" -test_metrics "return" "dialog" "bleu" "ppl_dialog_lm" "ttr_question" "sum_probs" "ppl" "lv_norm" "ttr" "selfbleu" "dialogimage" "language_score" "size_valid_actions" -answer_sampl "img_sampling" -init_text "Here are a few examples:" -custom_init 100
echo "------------------------------------proba thr(0.0075) + temp sch. - fusion average - GPT-2 -------------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VILBERT_VQA_fullvocab/temperature_pth_512_1024/answer_sampling/50000_ep" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.01 -lr 0.00005 -word_emb_size 128 -hidden_size 256 -num_episodes_train 100000 -debug "0,20000" -lm_path "gpt" -num_episodes_test 2000 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 5 -fusion "average" -condition_answer "after_fusion" -device_id 2 -temperature 1.5 -temp_step 5000 -temp_factor 0.75 -temp_min 1 -p_th 0.0075 -s_min 1 -entropy_coeff 0.01 -reward "vilbert_rank2" -reward_vocab "output/vilbert_vqav2/bert_base_6layer_6conect.json" -reward_path "output/vilbert_vqav2/model.bin" -test_metrics "return" "dialog" "bleu" "ppl_dialog_lm" "ttr_question" "sum_probs" "ppl" "lv_norm" "ttr" "selfbleu" "dialogimage" "language_score" "size_valid_actions" -answer_sampl "img_sampling" -init_text "Here are a few examples:" -custom_init 100
echo "------------------------------------proba thr(0.01) + temp sch. - fusion average - GPT-2 -------------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VILBERT_VQA_fullvocab/temperature_pth_512_1024/answer_sampling/50000_ep" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.01 -lr 0.00005 -word_emb_size 128 -hidden_size 256 -num_episodes_train 100000 -debug "0,20000" -lm_path "gpt" -num_episodes_test 2000 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 5 -fusion "average" -condition_answer "after_fusion" -device_id 3 -temperature 1.5 -temp_step 5000 -temp_factor 0.75 -temp_min 1 -p_th 0.01 -s_min 1 -entropy_coeff 0.01 -reward "vilbert_rank2" -reward_vocab "output/vilbert_vqav2/bert_base_6layer_6conect.json" -reward_path "output/vilbert_vqav2/model.bin" -test_metrics "return" "dialog" "bleu" "ppl_dialog_lm" "ttr_question" "sum_probs" "ppl" "lv_norm" "ttr" "selfbleu" "dialogimage" "language_score" "size_valid_actions" -answer_sampl "img_sampling" -init_text "Here are a few examples:" -custom_init 100

echo "------------------------------------proba thr - fusion average -------------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VILBERT_VQA_fullvocab/temperature_pth_512_1024/answer_sampling/50000_ep" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.01 -lr 0.00005 -word_emb_size 128 -hidden_size 256 -num_episodes_train 100000 -debug "0,20000" -lm_path "output/vqa_lm_model/model.pt" -num_episodes_test 2000 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 5 -fusion "average" -condition_answer "after_fusion" -device_id 0 -p_th 0.005 -s_min 1 -entropy_coeff 0.01 -reward "vilbert_rank2" -reward_vocab "output/vilbert_vqav2/bert_base_6layer_6conect.json" -reward_path "output/vilbert_vqav2/model.bin" -test_metrics "return" "dialog" "bleu" "ppl_dialog_lm" "ttr_question" "sum_probs" "ppl" "lv_norm" "ttr" "selfbleu" "dialogimage" "language_score" "size_valid_actions" -answer_sampl "img_sampling"
echo "------------------------------------proba thr + temp sch. - fusion average - KL_diff 0.01 -------------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VILBERT_VQA_fullvocab/temperature_pth_512_1024/answer_sampling/50000_ep" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.01 -lr 0.00005 -word_emb_size 128 -hidden_size 256 -num_episodes_train 100000 -debug "0,20000" -lm_path "output/vqa_lm_model/model.pt" -num_episodes_test 2000 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 5 -fusion "average" -condition_answer "after_fusion" -device_id 1 -temperature 1.5 -temp_step 5000 -temp_factor 0.75 -temp_min 1 -p_th 0.005 -s_min 1 -entropy_coeff 0.01 -reward "vilbert_rank2" -reward_vocab "output/vilbert_vqav2/bert_base_6layer_6conect.json" -reward_path "output/vilbert_vqav2/model.bin" -test_metrics "return" "dialog" "bleu" "ppl_dialog_lm" "ttr_question" "sum_probs" "ppl" "lv_norm" "ttr" "selfbleu" "dialogimage" "language_score" "size_valid_actions" -answer_sampl "img_sampling" -KL_coeff 0.01
echo "------------------------------------proba thr + temp sch. - fusion average - KL_diff 0.05 -------------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VILBERT_VQA_fullvocab/temperature_pth_512_1024/answer_sampling/50000_ep" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.01 -lr 0.00005 -word_emb_size 128 -hidden_size 256 -num_episodes_train 100000 -debug "0,20000" -lm_path "output/vqa_lm_model/model.pt" -num_episodes_test 2000 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 5 -fusion "average" -condition_answer "after_fusion" -device_id 2 -temperature 1.5 -temp_step 5000 -temp_factor 0.75 -temp_min 1 -p_th 0.005 -s_min 1 -entropy_coeff 0.01 -reward "vilbert_rank2" -reward_vocab "output/vilbert_vqav2/bert_base_6layer_6conect.json" -reward_path "output/vilbert_vqav2/model.bin" -test_metrics "return" "dialog" "bleu" "ppl_dialog_lm" "ttr_question" "sum_probs" "ppl" "lv_norm" "ttr" "selfbleu" "dialogimage" "language_score" "size_valid_actions" -answer_sampl "img_sampling" -KL_coeff 0.05
echo "------------------------------------proba thr + temp sch. - fusion average - KL_diff 0.1 -------------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VILBERT_VQA_fullvocab/temperature_pth_512_1024/answer_sampling/50000_ep" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.01 -lr 0.00005 -word_emb_size 128 -hidden_size 256 -num_episodes_train 100000 -debug "0,20000" -lm_path "output/vqa_lm_model/model.pt" -num_episodes_test 2000 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 5 -fusion "average" -condition_answer "after_fusion" -device_id 3 -temperature 1.5 -temp_step 5000 -temp_factor 0.75 -temp_min 1 -p_th 0.005 -s_min 1 -entropy_coeff 0.01 -reward "vilbert_rank2" -reward_vocab "output/vilbert_vqav2/bert_base_6layer_6conect.json" -reward_path "output/vilbert_vqav2/model.bin" -test_metrics "return" "dialog" "bleu" "ppl_dialog_lm" "ttr_question" "sum_probs" "ppl" "lv_norm" "ttr" "selfbleu" "dialogimage" "language_score" "size_valid_actions" -answer_sampl "img_sampling" -KL_coeff 0.1




