import os
import argparse

parser.add_argument('-r', '--resume', default=None, type=str,
                    help='path to latest checkpoint (default: None)')
parser.add_argument('-d', '--device', default=None, type=str,
                    help='indices of GPUs to enable (default: all)')
parser.add_argument('-s', '--seed', default=None, type=int,
                    help='random seed')
args = parser.parse_args()

#%%
def clear(checkpoint_dir):
    child_dirs = os.listdir(checkpoint_dir)
    for cdir in child_dirs:
        cdir = os.path.join(checkpoint_dir,cdir)
        checkpoint_files = os.listdir(cdir)
        if len(checkpoint_files) == 0:
            os.rmdir(cdir)
        elif len(checkpoint_files) == 1 and checkpoint_files[0] == "config.json":
            config = os.path.join(cdir, checkpoint_files[0])
            os.remove(config)
            os.rmdir(cdir)
# %%
if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Clear Empty Checkpoints')
    parser.add_argument('-p', '--path', default=None, type=str,
                    help='checkpoint dir')
    args = parser.parse_args()
    clear(args.path)