#!/usr/bin/env bash

TASK_NAME="cmnli"
MODEL_TYPE="robust-bert"
MODEL_NAME="robust-bert"
CURRENT_DIR=$(cd -P -- "$(dirname -- "$0")" && pwd -P)
export CUDA_VISIBLE_DEVICES="0"
export BERT_PRETRAINED_MODELS_DIR=$CURRENT_DIR/prev_trained_model
export BERT_WWM_DIR=$BERT_PRETRAINED_MODELS_DIR/$MODEL_NAME
export GLUE_DATA_DIR=$CURRENT_DIR/CLUEdatasets

# download and unzip dataset
if [ ! -d $GLUE_DATA_DIR ]; then
  mkdir -p $GLUE_DATA_DIR
  echo "makedir $GLUE_DATA_DIR"
fi
cd $GLUE_DATA_DIR
if [ ! -d $TASK_NAME ]; then
  mkdir $TASK_NAME
  echo "makedir $GLUE_DATA_DIR/$TASK_NAME"
fi
cd $TASK_NAME
if [ ! -f "train.json" ] || [ ! -f "dev.json" ] || [ ! -f "test.json" ]; then
  rm *
  wget https://storage.googleapis.com/cluebenchmark/tasks/cmnli_public.zip
  unzip cmnli_public.zip
  rm cmnli_public.zip
else
  echo "data exists"
fi
echo "Finish download dataset."

# make output dir
if [ ! -d $CURRENT_DIR/output/${TASK_NAME}_output ]; then
  mkdir -p $CURRENT_DIR/output/${TASK_NAME}_output
  echo "makedir $CURRENT_DIR/output/${TASK_NAME}_output"
fi

# run task
cd $CURRENT_DIR
echo "Start running..."
if [ $# == 0 ]; then
    python run_classifier.py \
      --model_type=$MODEL_TYPE \
      --model_name_or_path=$BERT_WWM_DIR \
      --tokenizer_path=$BERT_WWM_DIR \
      --prev_model_path=$BERT_WWM_DIR \
      --task_name=$TASK_NAME \
      --do_train \
      --do_eval \
      --do_lower_case \
      --data_dir=$GLUE_DATA_DIR/${TASK_NAME}/ \
      --max_seq_length=128 \
      --per_gpu_train_batch_size=16 \
      --per_gpu_eval_batch_size=16 \
      --learning_rate=3e-5 \
      --num_train_epochs=3.0 \
      --logging_steps=24487 \
      --save_steps=24487 \
      --output_dir=$CURRENT_DIR/output/${TASK_NAME}_output/ \
      --overwrite_output_dir \
      --seed=42 \
      --save_best
elif [ $1 == "predict" ]; then
    echo "Start predict..."
    python run_classifier.py \
      --model_type=$MODEL_TYPE \
      --model_name_or_path=$MODEL_NAME \
      --tokenizer_path=$BERT_WWM_DIR \
      --prev_model_path=$BERT_WWM_DIR \
      --task_name=$TASK_NAME \
      --do_predict \
      --do_lower_case \
      --data_dir=$GLUE_DATA_DIR/${TASK_NAME}/ \
      --max_seq_length=128 \
      --per_gpu_train_batch_size=16 \
      --per_gpu_eval_batch_size=16 \
      --learning_rate=3e-5 \
      --num_train_epochs=3.0 \
      --logging_steps=24487 \
      --save_steps=24487 \
      --output_dir=$CURRENT_DIR/output/${TASK_NAME}_output/ \
      --overwrite_output_dir \
      --seed=42
elif [ $1 == "evaluate" ]; then
    echo "Start evaluate..."
    python run_classifier.py \
      --model_type=$MODEL_TYPE \
      --model_name_or_path=$CURRENT_DIR/output/${TASK_NAME}_output/$MODEL_TYPE/checkpoint-best \
      --tokenizer_path=$BERT_WWM_DIR \
      --prev_model_path=$BERT_WWM_DIR \
      --task_name=$TASK_NAME \
      --do_eval \
      --do_lower_case \
      --data_dir=$GLUE_DATA_DIR/${TASK_NAME}/ \
      --max_seq_length=128 \
      --per_gpu_train_batch_size=16 \
      --per_gpu_eval_batch_size=16 \
      --learning_rate=2e-5 \
      --num_train_epochs=3.0 \
      --logging_steps=759 \
      --save_steps=759 \
      --output_dir=$CURRENT_DIR/output/${TASK_NAME}_output/ \
      --overwrite_output_dir \
      --seed=42 \
      --dev_middle_name=attack3.r_0.1.
    echo "Start evaluate..."
    python run_classifier.py \
      --model_type=$MODEL_TYPE \
      --model_name_or_path=$CURRENT_DIR/output/${TASK_NAME}_output/$MODEL_TYPE/checkpoint-best \
      --tokenizer_path=$BERT_WWM_DIR \
      --prev_model_path=$BERT_WWM_DIR \
      --task_name=$TASK_NAME \
      --do_eval \
      --do_lower_case \
      --data_dir=$GLUE_DATA_DIR/${TASK_NAME}/ \
      --max_seq_length=128 \
      --per_gpu_train_batch_size=16 \
      --per_gpu_eval_batch_size=16 \
      --learning_rate=2e-5 \
      --num_train_epochs=3.0 \
      --logging_steps=759 \
      --save_steps=759 \
      --output_dir=$CURRENT_DIR/output/${TASK_NAME}_output/ \
      --overwrite_output_dir \
      --seed=42 \
      --dev_middle_name=attack3.r_0.2.
    echo "Start evaluate..."
    python run_classifier.py \
      --model_type=$MODEL_TYPE \
      --model_name_or_path=$CURRENT_DIR/output/${TASK_NAME}_output/$MODEL_TYPE/checkpoint-best \
      --tokenizer_path=$BERT_WWM_DIR \
      --prev_model_path=$BERT_WWM_DIR \
      --task_name=$TASK_NAME \
      --do_eval \
      --do_lower_case \
      --data_dir=$GLUE_DATA_DIR/${TASK_NAME}/ \
      --max_seq_length=128 \
      --per_gpu_train_batch_size=16 \
      --per_gpu_eval_batch_size=16 \
      --learning_rate=2e-5 \
      --num_train_epochs=3.0 \
      --logging_steps=759 \
      --save_steps=759 \
      --output_dir=$CURRENT_DIR/output/${TASK_NAME}_output/ \
      --overwrite_output_dir \
      --seed=42 \
      --dev_middle_name=attack3.r_0.3.
    echo "Start evaluate..."
    python run_classifier.py \
      --model_type=$MODEL_TYPE \
      --model_name_or_path=$CURRENT_DIR/output/${TASK_NAME}_output/$MODEL_TYPE/checkpoint-best \
      --tokenizer_path=$BERT_WWM_DIR \
      --prev_model_path=$BERT_WWM_DIR \
      --task_name=$TASK_NAME \
      --do_eval \
      --do_lower_case \
      --data_dir=$GLUE_DATA_DIR/${TASK_NAME}/ \
      --max_seq_length=128 \
      --per_gpu_train_batch_size=16 \
      --per_gpu_eval_batch_size=16 \
      --learning_rate=2e-5 \
      --num_train_epochs=3.0 \
      --logging_steps=759 \
      --save_steps=759 \
      --output_dir=$CURRENT_DIR/output/${TASK_NAME}_output/ \
      --overwrite_output_dir \
      --seed=42 \
      --dev_middle_name=attack3.r_0.5.
    echo "Start evaluate..."
    python run_classifier.py \
      --model_type=$MODEL_TYPE \
      --model_name_or_path=$CURRENT_DIR/output/${TASK_NAME}_output/$MODEL_TYPE/checkpoint-best \
      --tokenizer_path=$BERT_WWM_DIR \
      --prev_model_path=$BERT_WWM_DIR \
      --task_name=$TASK_NAME \
      --do_eval \
      --do_lower_case \
      --data_dir=$GLUE_DATA_DIR/${TASK_NAME}/ \
      --max_seq_length=128 \
      --per_gpu_train_batch_size=16 \
      --per_gpu_eval_batch_size=16 \
      --learning_rate=2e-5 \
      --num_train_epochs=3.0 \
      --logging_steps=759 \
      --save_steps=759 \
      --output_dir=$CURRENT_DIR/output/${TASK_NAME}_output/ \
      --overwrite_output_dir \
      --seed=42 \
      --dev_middle_name=attack3.r_0.5.random.
fi
