# Analysis Code for Bias Transfer Paper

Requires R. Make sure to set your working directory to this directory.

All the files listed below should be included in the same directory.

## Contents

- `analysis.Rmd` - code for generating main figures and running regressions
- `data` - auxiliary data for labeling plots (e.g. regression results as CSV)
- `plots` - figures generated for the paper
- `output` - output of our experiments (code for experiments not included - not permitted to share) - one file for each task and one for the alternative upstream metric for Wiki
- `results` - regression tables and other result outputs

## Experiment Data
The data in `output` is the direct result of our experiments. Relevant field descriptions are included below.

### Bios
Data are grouped by model, target, & template.
- `model` - the model run, including the following parameters separated by underscores:
  - the model architecture (e.g. RoBERTa)
  - the task (e.g. bios)
  - the date the model was fine-tuned
  - any additional interventions with parameters - see `analysis.Rmd` for interpretation
- `label` - the occupation
- `label_text` - the occupation description
- `target` - the target pronoun for this log likelihood measurement
- `log_probs` - the log likelihood of `target`
- `gender` - original gender tag from `Bios` dataset - `M` indicates he/him pronouns, `F` she/her pronouns (note that this is misleading - these biographies do not contain self-identified gender)
- `template` - which template was used to generate this score
- `log_probs_inter` - log likelihood *after* fine-tuning
- `tpr_f` - TPR for she/her pronouns
- `tpr_m` - TPR for he/him pronouns
- `prev_f` - prevalance of she/her pronouns for `label` in training data
- `pref_f_test` - "" for test data
- `prev_occ` - prevalence of `label` in training data
- `model_acc` - test accuracy of this model

### Wiki
- `model` - the model run, including the following parameters separated by underscores:
  - the model architecture (e.g. RoBERTa)
  - the task (e.g. bios)
  - the date the model was fine-tuned
  - any additional interventions with parameters - see `analysis.Rmd` for interpretation
- `identity` - the identity term
- `template` - which template was used to generate this score
- `score_*` - average sentiment scores for the predictions for this template
- `fpr` - FPR for this identity term
- `fpr_agg` - overall FPR
- `prev_toxic` - proportion of mentions of `identity` which are toxic in the training data
- `prev_toxic_test` - "" in the test data
- `prev_identity` - prevalence of `identity` in the training data
- `prev_identity_test` - "" in the test data
- `comment_length_avg` - average comment length for commetns containing `identity` in the training data
- `comment_length_*` - "" for the subset \*
- `model_acc` - test accuracy of this model


## Compiling Code for Release

`zip -r data.zip README.md output data`

`zip -r software.zip README.md analysis.Rmd plots results`