from io import open
from setuptools import find_packages, setup


extras = {
    'serving': ['uvicorn', 'fastapi']
}
extras['all'] = [package for package in extras.values()]

setup(
    name="transformers",
    version="2.2.2",
    license='Apache',
    packages=find_packages(exclude=["*.tests", "*.tests.*",
                                    "tests.*", "tests"]),
    install_requires=['torch == 1.6.0',
                      'numpy',
                      'boto3',
                      'requests',
                      'tqdm',
                      'regex',
                      'sentencepiece',
                      'sacremoses',
                      'pypinyin',
                      'pillow',
                      'opencc'],
    entry_points={
      'console_scripts': [
        "transformers=transformers.__main__:main",
      ]
    },
    extras_require=extras
)
