# TOC

- [DB diagram](#db-diagram)
- [Table Details](#table-details)
    * [users](#users)
    * [tasks](#tasks)
    * [annotations](#annotations)
    * [users_tasks](#users_tasks)
    * [users_annotations](#users_annotations)
    * [user_annotations_logs](#user_annotations_logs)

# DB diagram
<img src="https://github.com/CyberAgent/fast-annotation-tool/blob/main/docs/imgs/db_latest.png?raw=true" alt="image" width=700 />

# Table Details

## users

User Information

| name       | type                              | example                   | comment |
| ---------- | --------------------------------- | ------------------------- | ------- |
| id         | string (unique)                   | 123hoge                   |         |
| name       | string                            | Taro Yamada                  |         |
| email      | string                            | dews(at)gmail.com         |         |
| role       | role_type: "admin" \| "annotator" | admin                     |         |
| photo_url  | string                            | http(s)://dews.png        |         |
| created_at | timestamp                         | 2020/01/01 10:00:00 UTC+9 |         |
| updated_at | timestamp                         | 2020/01/01 10:00:00 UTC+9 |         |



## tasks

Task Information


| name            | type                                     | example                                                  | comment                                      |
| --------------- | ---------------------------------------- | -------------------------------------------------------- | -------------------------------------------- |
| id              | string (unique)                          | demo-annotation                                 |                                              |
| annotation_type | annotation_type: "card" \| "multi_label" | card                                                     | Which annotation UI to use.               |
| title           | string                                   | Check for broken sentences         | Title of the task to be displayed on the main page.   |
| description     | string                                   | This is an annotation to check whether the generated text is collapsed or not. | A detailed description of the task to be displayed on the main page. |
| question        | string                                   | Is this sentence broken?                   | Question text to be displayed in the annotation screen.         |
| created_at      | timestamp                                | 2020/01/01 10:00:00 UTC+9                                |                                              |
| updated_at      | timestamp                                | 2020/01/01 10:00:00 UTC+9                                |                                              |



## annotations

Specific data for annotation

| name       | type            | example                                                      | comment                                                      |
| ---------- | --------------- | ------------------------------------------------------------ | ------------------------------------------------------------ |
| id         | string (unique) | hoge123                                                      |                                                              |
| task_id    | string          | demo-annotation                                |                                                              |
| data       | dict            | `{"text": "This is a pen", "show_ambiguous_button": true}` | Contents of annotation data, including meta-information. Depends on tasks.annotation_type. |
| created_at | timestamp       | 2020/01/01 10:00:00 UTC+9                                    |                                                              |
| updated_at | timestamp       | 2020/01/01 10:00:00 UTC+9                                    |                                                              |

For the schema of annotations.data, go to [[Task-dependent schema]].


## users_tasks

Tasks that have actually been assigned to users.

| name           | type            | example                   | comment                                |
| -------------- | --------------- | ------------------------- | -------------------------------------- |
| id             | string (unique) | hoge123                   |                                        |
| user_id        | string          | hoge123                   |                                        |
| task_id        | string          | demo-annotation  |                                        |
| annotation_num | int             | 1000                      | Number of annotations assigned to the user |
| submitted_num  | int             | 10                        | Number of user-submitted annotations.       |
| created_at     | timestamp       | 2020/01/01 10:00:00 UTC+9 |                                        |
| updated_at     | timestamp       | 2020/01/01 10:00:00 UTC+9 |                                        |



## users_annotations

Annotations that were actually assigned to the user.


| name          | type            | example                   | comment                                                      |
| ------------- | --------------- | ------------------------- | ------------------------------------------------------------ |
| id            | string (unique) | hoge123                   |                                                              |
| user_id       | string          | hoge123                   |                                                              |
| annotation_id | string          | hoge123                   |                                                              |
| user_task_id  | string          | hoge123                   |                                                              |
| order_index   | int             | 20                        | Index of annotations. 1 <= order_index <= users_tasks.annotation_num |
| result_data   | dict            | `{"result": "Yes"}`       | User's response, depending on tasks.annotation_type.                  |
| created_at    | timestamp       | 2020/01/01 10:00:00 UTC+9 |                                                              |
| updated_at    | timestamp       | 2020/01/01 10:00:00 UTC+9 |                                                              |

For the schema of users_annotations.result_data, go to [[Task-dependent schema]].



## user_annotations_logs

Log of actions taken by the user during annotation.


| name               | type                                  | example                   | comment                  |
| ------------------ | ------------------------------------- | ------------------------- | ------------------------ |
| id                 | string (unique)                       | hoge123                   |                          |
| user_task_id       | string                                | hoge123                   |                          |
| user_annotation_id | string                                | hoge123                   |                          |
| action_type        | "display", "select", "submit", "back" | select                    | Type of action         |
| action_data        | dict                                  | {'choice': 'hoge'}        | Detailed data in action |
| created_at         | timestamp                             | 2020/01/01 10:00:00 UTC+9 |                          |