/*
 * Decompiled with CFR 0.152.
 */
package se.liu.ida.nlp.sdp.toolkit.tools;

import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import se.liu.ida.nlp.sdp.toolkit.graph.Edge;
import se.liu.ida.nlp.sdp.toolkit.graph.Graph;
import se.liu.ida.nlp.sdp.toolkit.graph.InspectedGraph;
import se.liu.ida.nlp.sdp.toolkit.graph.Node;
import se.liu.ida.nlp.sdp.toolkit.io.GraphReader2015;

public class Analyzer {
    private int nGraphs;
    private int nNonWallNodes;
    private int nEdges;
    private final Set<String> labels = new HashSet<String>();
    private int nSingletons;
    private int nCyclic;
    private int nForests;
    private int nTrees;
    private int nFragmented;
    private int nReentrantNodes;
    private int nToplessGraphs;
    private int nTopNodes;
    private int nSpecialNodes;
    private int nNoncrossingGraphs;
    private int nProjectiveGraphs;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getIntegerInstance(Locale.ENGLISH);
    private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance(Locale.ENGLISH);

    public void update(Graph graph) {
        InspectedGraph inspectedGraph = new InspectedGraph(graph);
        ++this.nGraphs;
        this.nNonWallNodes += inspectedGraph.getNNonWallNodes();
        this.nEdges += graph.getNEdges();
        for (Edge edge : graph.getEdges()) {
            this.labels.add(edge.label);
        }
        this.nSingletons += inspectedGraph.getNSingletons();
        this.nCyclic += inspectedGraph.isCyclic() ? 1 : 0;
        this.nForests += inspectedGraph.isForest() ? 1 : 0;
        this.nTrees += inspectedGraph.isTree() ? 1 : 0;
        this.nFragmented += inspectedGraph.getNComponents() - 1 - inspectedGraph.getNSingletons() == 1 ? 0 : 1;
        for (Node node : graph.getNodes()) {
            this.nReentrantNodes += node.getNIncomingEdges() > 1 ? 1 : 0;
        }
        boolean isTopless = true;
        for (Node node : graph.getNodes()) {
            isTopless = isTopless && !node.isTop;
        }
        this.nToplessGraphs += isTopless ? 1 : 0;
        for (Node node : graph.getNodes()) {
            this.nTopNodes += node.isTop ? 1 : 0;
        }
        for (Node node : graph.getNodes()) {
            this.nSpecialNodes += node.id != 0 && !inspectedGraph.isSingleton(node.id) && !node.hasIncomingEdges() && !node.isTop ? 1 : 0;
        }
        this.nNoncrossingGraphs += inspectedGraph.isNoncrossing() ? 1 : 0;
        this.nProjectiveGraphs += inspectedGraph.isProjective() ? 1 : 0;
    }

    public static void main(String[] args) throws Exception {
        Analyzer analyzer = new Analyzer();
        for (String arg : args) {
            Graph graph;
            GraphReader2015 reader = new GraphReader2015(arg);
            while ((graph = reader.readGraph()) != null) {
                analyzer.update(graph);
            }
            reader.close();
        }
        System.err.format("number of graphs: %d%n", analyzer.nGraphs);
        System.err.format("number of non-wall nodes: %d%n", analyzer.nNonWallNodes);
        System.err.format("number of distinct labels: %d%n", analyzer.labels.size());
        System.err.format("percentage of singleton nodes (over all non-wall nodes): %s%n", Analyzer.percentage(analyzer.nSingletons, analyzer.nNonWallNodes));
        System.err.format("edge density (proportion of edge counts to non-singleton nodes): %s%n", Analyzer.fraction(analyzer.nEdges, analyzer.nNonWallNodes - analyzer.nSingletons));
        System.err.format("percentage of cyclic graphs: %s%n", Analyzer.percentage(analyzer.nCyclic, analyzer.nGraphs));
        System.err.format("percentage of graphs that are forests: %s%n", Analyzer.percentage(analyzer.nForests, analyzer.nGraphs));
        System.err.format("percentage of graphs that are trees: %s%n", Analyzer.percentage(analyzer.nTrees, analyzer.nGraphs));
        System.err.format("percentage of graphs that are fragmented: %s%n", Analyzer.percentage(analyzer.nFragmented, analyzer.nGraphs));
        System.err.format("percentage of (non-singleton) nodes that are reentrant: %s%n", Analyzer.percentage(analyzer.nReentrantNodes, analyzer.nNonWallNodes - analyzer.nSingletons));
        System.err.format("percentage of topless graphs: %s%n", Analyzer.percentage(analyzer.nToplessGraphs, analyzer.nGraphs));
        System.err.format("average number of top nodes per graph: %s%n", Analyzer.fraction(analyzer.nTopNodes, analyzer.nGraphs));
        System.err.format("percentage of (non-singleton) nodes with indegree = 0 that are not top: %s%n", Analyzer.percentage(analyzer.nSpecialNodes, analyzer.nNonWallNodes - analyzer.nSingletons));
        System.err.format("percentage of noncrossing graphs: %s%n", Analyzer.percentage(analyzer.nNoncrossingGraphs, analyzer.nGraphs));
        System.err.format("percentage of projective graphs: %s%n", Analyzer.percentage(analyzer.nProjectiveGraphs, analyzer.nGraphs));
    }

    public static String fraction(int a, int b) {
        return NUMBER_FORMAT.format((double)a / (double)b);
    }

    public static String percentage(int enumerator, int denominator) {
        return PERCENT_FORMAT.format((double)enumerator / (double)denominator);
    }

    static {
        NUMBER_FORMAT.setMinimumFractionDigits(4);
        NUMBER_FORMAT.setMaximumFractionDigits(4);
        PERCENT_FORMAT.setMinimumFractionDigits(2);
        PERCENT_FORMAT.setMaximumFractionDigits(2);
    }
}

