function opts = mergeOptions(opts_sub, opts_master)
% Merges two options structures with one having precedence over the other.
%
% function opts = mergeOptions(opts1, opts2)
%
% input: opts1 and opts2 are two structures.
% output: opts is a structure containing all fields of opts1 and opts2.
% Whenever a field is present in both opts1 and opts2, it is the value in
% opts2 that is kept.
%
% The typical usage is to have opts1 contain default options and opts2
% contain user-specified options that overwrite the defaults.
%
% See also: getGlobalDefaults

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, Dec. 30, 2012.
% Contributors: 
% Change log: 


    if isempty(opts_sub)
        opts_sub = struct();
    end
    if isempty(opts_master)
        opts_master = struct();
    end

    opts = opts_sub;
    fields = fieldnames(opts_master);
    for i = 1 : length(fields)
        opts.(fields{i}) = opts_master.(fields{i});
    end
    
end
