/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Word;

public class Preposition
extends Word {
    Case governedCase;
    String leftForm;
    String rightForm;

    public Preposition(String baseform) {
        super(baseform);
        this.category = Category.PREPOSITION;
        this.governedCase = Case.ACCUSATIVE;
        this.leftForm = this.baseForm;
        this.rightForm = "";
    }

    public Preposition(String baseform, Case caseValue) {
        this(baseform);
        this.governedCase = caseValue;
    }

    public Preposition(String baseform, Case caseValue, boolean postpos) {
        this(baseform, caseValue);
        this.leftForm = "";
        this.rightForm = this.baseForm;
    }

    public Preposition(String leftform, String rightform, Case caseValue) {
        this(leftform + " ... " + rightform, caseValue);
        this.leftForm = leftform;
        this.rightForm = rightform;
    }

    public Preposition(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Preposition(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setID(id);
        this.setCitationForm(citationform);
    }

    public Case getGovernedCase() {
        return this.governedCase;
    }

    public void setGovernedCase(Case governedCase) {
        this.governedCase = governedCase;
    }

    public String getLeftForm() {
        return this.leftForm;
    }

    public void setLeftForm(String leftForm) {
        this.leftForm = leftForm;
    }

    public String getRightForm() {
        return this.rightForm;
    }

    public void setRightForm(String rightForm) {
        this.rightForm = rightForm;
    }

    public boolean isPostpositional() {
        return this.leftForm.equals("");
    }

    @Deprecated
    public static Preposition getPreposition(String baseform) {
        return Constants.getPreposition(baseform);
    }
}

