/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.features;

import simplenlg.exception.LexiconException;
import simplenlg.features.ComplementType;
import simplenlg.features.InterpretationCode;
import simplenlg.lexicon.lexicalitems.LexicalItem;

public class ComplementSlot {
    private ComplementType type;
    private InterpretationCode code;
    private LexicalItem headRestriction;

    ComplementSlot() {
    }

    public ComplementSlot(ComplementType t) {
        this();
        this.setType(t);
    }

    public ComplementSlot(ComplementType t, InterpretationCode c, LexicalItem r) {
        this(t);
        this.setCode(c);
        this.setHeadRestriction(r);
    }

    public ComplementType getType() {
        return this.type;
    }

    public void setType(ComplementType type) throws LexiconException {
        if (this.code != null) {
            if (this.code.compatibleWith(type)) {
                this.type = type;
                return;
            }
            throw new LexiconException("The interpretation code " + (Object)((Object)this.code) + " is incompatible with the complement type " + (Object)((Object)type));
        }
        this.type = type;
    }

    public InterpretationCode getCode() {
        return this.code;
    }

    public void setCode(InterpretationCode code) {
        if (code == null) {
            return;
        }
        if (!code.compatibleWith(this.type)) {
            throw new LexiconException("The interpretation code " + (Object)((Object)code) + " is incompatible with the complement type " + (Object)((Object)this.type));
        }
        this.code = code;
    }

    public LexicalItem getHeadRestriction() {
        return this.headRestriction;
    }

    public void setHeadRestriction(LexicalItem headRestriction) {
        this.headRestriction = headRestriction;
    }

    boolean hasHeadRestriction() {
        return this.headRestriction != null;
    }

    boolean hasInterpretationCode() {
        return this.code != null;
    }
}

