/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.pear.dag;

import edu.pku.coli.io.CCGPARGWriter;
import edu.pku.coli.io.DAGSentenceReader;
import edu.pku.coli.io.FileFilters;
import edu.pku.coli.pear.dag.Evaluator;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import edu.pku.coli.treeapprox.DAG2TreeBFS;
import edu.pku.coli.treeapprox.DAG2TreeDFS;
import edu.pku.coli.treeapprox.DAG2TreeDFS_ForwardEdgeFirst;
import edu.pku.coli.treeapprox.DAG2TreeNonProjectiveSimple;
import edu.pku.coli.treeapprox.DAG2TreeProjectiveSimple;
import edu.pku.coli.treeapprox.DAG2TreeTransformer;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class DAGFormatTransformer
implements Runnable {
    @Option
    public String pargDir = null;
    @Option
    public String conll08Dir = null;
    @Option
    public String autoDir = null;
    @Option
    public String conll06Dir = null;
    @Option
    public String xmlDir = null;
    @Option
    public String sdpDir = null;
    @Option
    public String sdp15Dir = null;
    @Option
    public boolean asTree = false;
    @Option
    public boolean withTree = false;
    @Option
    public String out = null;
    @Option
    public boolean reverse = false;
    @Option
    public String sections = "all";
    @Option
    public boolean toTree = false;
    @Option
    public String toTreeAlgo = "dfs";
    @Option
    public boolean toTreeArg1 = false;
    @Option
    public String toTreeArg2 = "both";
    @Option
    public String toTreeArg3 = "level";
    @Option
    public String targetFormat = "conll08";
    @Option
    public boolean addExplicitRoot = false;
    @Option
    public boolean unlab = false;
    private DAG2TreeTransformer dag2Tree;
    CCGPARGWriter _writer;
    FileFilter _sectionFileFilter;

    public static void main(String[] args) {
        Execution.run(args, new DAGFormatTransformer());
    }

    @Override
    public void run() {
        CCGPARGWriter.UNLAB = this.unlab;
        this._sectionFileFilter = FileFilters.sectionFileFilter(this.sections);
        DAGSentenceReader dagReader = this.getDagReader();
        this._writer = new CCGPARGWriter(this.out);
        this.toConll08(dagReader);
        this._writer.close();
    }

    public void toConll08(Iterable<SentenceForDAGParsing> sents) {
        Evaluator e = new Evaluator();
        if (this.toTree) {
            this.setToTreeTransformer();
        }
        Iterator<SentenceForDAGParsing> treeit = null;
        if (!this.asTree && this.conll06Dir != null) {
            treeit = DAGSentenceReader.treesReaderFromCoNLL06(this.conll06Dir).iterator();
        }
        for (SentenceForDAGParsing sent : sents) {
            if (this.reverse) {
                sent = sent.reverse();
            }
            PredicateArgumentAdjunctDAG tree = null;
            if (this.toTree) {
                tree = this.dag2Tree.toTree(sent.goldDAG);
                e.registry(sent.goldDAG, this.dag2Tree.toDAG(tree));
            } else if (treeit != null) {
                tree = treeit.next().getGoldDAG();
            }
            if (this.withTree) {
                tree = sent.getSyntaxTree();
            }
            if (this.targetFormat.equalsIgnoreCase("conll08")) {
                ArrayList<String> lowerwords = new ArrayList<String>();
                String[] stringArray = sent.words();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String w = stringArray[n2];
                    lowerwords.add(w.toLowerCase());
                    ++n2;
                }
                this._writer.printOneSentenceCoNLL08(sent.getGoldDAG(), tree, lowerwords, Arrays.asList(sent.tags()), this.addExplicitRoot);
                continue;
            }
            if (this.targetFormat.equalsIgnoreCase("conll09")) {
                this._writer.printOneSentenceCoNLL09(sent.getGoldDAG(), tree, Arrays.asList(sent.words()), Arrays.asList(sent.lemmas()), Arrays.asList(sent.tags()), this.addExplicitRoot);
                continue;
            }
            if (!this.targetFormat.equalsIgnoreCase("sdp")) continue;
            sent.getGoldDAG().addArc(0, tree.getOneRightArc((int)0).rightIndex, "root");
            this._writer.printOneSentenceSDP(sent.getGoldDAG(), Arrays.asList(sent.words()), Arrays.asList(sent.lemmas()), Arrays.asList(sent.tags()), "#20000000");
        }
        if (this.toTree) {
            System.out.println("DAG to Tree eval:\n" + e);
        }
    }

    private void setToTreeTransformer() {
        if (this.toTreeAlgo.equalsIgnoreCase("DFS")) {
            this.dag2Tree = new DAG2TreeDFS(this.toTreeArg1, this.toTreeArg2, this.toTreeArg3);
        } else if (this.toTreeAlgo.equalsIgnoreCase("forwardedgefirst")) {
            this.dag2Tree = new DAG2TreeDFS_ForwardEdgeFirst(this.toTreeArg1, this.toTreeArg2, this.toTreeArg3);
        } else if (this.toTreeAlgo.equalsIgnoreCase("bfs")) {
            this.dag2Tree = new DAG2TreeBFS(this.toTreeArg1, this.toTreeArg2, this.toTreeArg3);
        } else if (this.toTreeAlgo.equalsIgnoreCase("projective")) {
            this.dag2Tree = new DAG2TreeProjectiveSimple(this.toTreeArg1);
        } else if (this.toTreeAlgo.equalsIgnoreCase("nonprojective")) {
            this.dag2Tree = new DAG2TreeNonProjectiveSimple(this.toTreeArg1);
        }
    }

    private DAGSentenceReader getDagReader() {
        if (this.asTree) {
            if (this.conll08Dir != null) {
                return DAGSentenceReader.treesReaderFromCoNLL08(this.conll08Dir);
            }
            if (this.conll06Dir != null) {
                return DAGSentenceReader.treesReaderFromCoNLL06(this.conll06Dir);
            }
        } else {
            if (this.conll08Dir != null) {
                return DAGSentenceReader.dagsReaderFromCoNLL08(this.conll08Dir, this.withTree);
            }
            if (this.conll06Dir != null) {
                return DAGSentenceReader.dagsReaderFromPARGwithCoNLL06(new File(this.pargDir), new File(this.conll06Dir), false);
            }
            if (this.autoDir != null) {
                return DAGSentenceReader.dagsReaderFromPARGwithCCGBank(new File(this.pargDir), this._sectionFileFilter, new File(this.autoDir), this._sectionFileFilter);
            }
            if (this.xmlDir != null) {
                return DAGSentenceReader.dagsReaderFromXML(this.xmlDir, false);
            }
            if (this.sdpDir != null) {
                return DAGSentenceReader.dagsReaderFromSDP(this.sdpDir);
            }
            if (this.sdp15Dir != null) {
                return DAGSentenceReader.dagsReaderFromSDP15(this.sdp15Dir);
            }
        }
        return null;
    }
}

