/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.treesegs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import matetools.is2.data.Cluster;
import matetools.is2.data.DataFES;
import matetools.is2.data.F2SF;
import matetools.is2.data.FV;
import matetools.is2.data.Instances;
import matetools.is2.data.Long2Int;
import matetools.is2.data.Long2IntInterface;
import matetools.is2.data.Parse;
import matetools.is2.data.PipeGen;
import matetools.is2.data.SentenceData09;
import matetools.is2.io.CONLLReader09;
import matetools.is2.io.CONLLWriter09;
import matetools.is2.modification.io.CONLLReader08;
import matetools.is2.modification.io.CONLLWriter08;
import matetools.is2.modification.morefeatures.MoreFeaturesInterface;
import matetools.is2.modification.treesegs.NoSegmentation;
import matetools.is2.modification.treesegs.RandomTreeSegmentation;
import matetools.is2.modification.treesegs.TreeSegmentation;
import matetools.is2.modification.treesegs.TreeSegmentsExtractor;
import matetools.is2.modification.treesegs.TreeSegmentsPipe;
import matetools.is2.parser.Decoder;
import matetools.is2.parser.Edges;
import matetools.is2.parser.MFO;
import matetools.is2.parser.Options;
import matetools.is2.parser.Parameters;
import matetools.is2.parser.ParametersFloat;
import matetools.is2.tools.Retrainable;
import matetools.is2.tools.Tool;
import matetools.is2.util.DB;
import matetools.is2.util.OptionsSuper;
import matetools.is2.util.ParserEvaluator;

public class TreeSegmentsParser
implements Tool,
Retrainable {
    protected static final boolean MAX_INFO = true;
    public static int THREADS = 4;
    public Long2IntInterface l2i;
    public ParametersFloat params;
    public TreeSegmentsPipe pipe;
    public OptionsSuper options;
    public Instances is;
    DataFES d2;
    public Parse d = null;
    CONLLReader09 reader = new CONLLReader09(true);

    public TreeSegmentsParser(OptionsSuper options) {
        this.options = options;
        this.pipe = new TreeSegmentsPipe(options);
        this.params = new ParametersFloat(0);
        try {
            this.readModel(options, this.pipe, this.params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TreeSegmentsParser(String modelFileName) {
        this(new Options(new String[]{"-model", modelFileName}));
    }

    public TreeSegmentsParser() {
    }

    private static TreeSegmentation getTreeSegmentation(String[] args) {
        int i = 0;
        while (i < args.length) {
            if ("-treeseg".equalsIgnoreCase(args[i])) {
                if ("noseg".equalsIgnoreCase(args[i + 1])) {
                    return new NoSegmentation();
                }
                if ("randseg".equalsIgnoreCase(args[i + 1])) {
                    return new RandomTreeSegmentation();
                }
                throw new RuntimeException("Unkown Tree Segmentation");
            }
            ++i;
        }
        return new RandomTreeSegmentation();
    }

    public static void main(String[] args) throws Exception {
        TreeSegmentsParser p;
        long start = System.currentTimeMillis();
        Options options = new Options(args);
        Runtime runtime = Runtime.getRuntime();
        THREADS = runtime.availableProcessors();
        if (options.cores < THREADS && options.cores > 0) {
            THREADS = options.cores;
        }
        DB.println("Found " + runtime.availableProcessors() + " cores use " + THREADS);
        MoreFeaturesInterface.initialize(options.moreFeatures);
        if (options.train) {
            p = new TreeSegmentsParser();
            p.options = options;
            MoreFeaturesInterface.l2i = p.l2i = new Long2Int(options.hsize);
            p.pipe = new TreeSegmentsPipe(options);
            p.pipe.treeSeg = TreeSegmentsParser.getTreeSegmentation(args);
            Instances is = new Instances();
            TreeSegmentsExtractor.initFeatures();
            p.pipe.extractor = new TreeSegmentsExtractor[THREADS];
            DB.println("hsize " + options.hsize);
            DB.println("Use " + (options.featureCreation == 1 ? "multiplication" : "shift") + "-based feature creation function");
            int t = 0;
            while (t < THREADS) {
                p.pipe.extractor[t] = new TreeSegmentsExtractor(p.l2i, options.stack, options.featureCreation);
                ++t;
            }
            DB.println("Stacking " + options.stack);
            p.pipe.createInstances(options.trainfile, is);
            p.params = new ParametersFloat(p.l2i.size());
            p.train(options, p.pipe, p.params, is, p.pipe.cl);
            p.writeModell(options, p.params, null, p.pipe.cl);
        }
        if (options.test) {
            p = new TreeSegmentsParser(options);
            DB.println("label only? " + options.label);
            p.out(options, p.pipe, p.params, false, options.label);
        }
        System.out.println();
        if (options.eval) {
            System.out.println("\nEVALUATION PERFORMANCE:");
            ParserEvaluator.evaluate(options.goldfile, options.outfile);
        }
        long end = System.currentTimeMillis();
        System.out.println("used time " + (float)((end - start) / 100L) / 10.0f);
        Decoder.executerService.shutdown();
        TreeSegmentsPipe.executerService.shutdown();
        System.out.println("end.");
    }

    public void readModel(OptionsSuper options, TreeSegmentsPipe pipe, Parameters params) throws IOException {
        DataInputStream dis;
        block5: {
            DB.println("Reading data started");
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(options.modelName)));
            zis.getNextEntry();
            dis = new DataInputStream(new BufferedInputStream(zis));
            pipe.mf.read(dis);
            pipe.cl = new Cluster(dis);
            params.read(dis);
            this.l2i = new Long2Int(params.size());
            DB.println("parsing -- li size " + this.l2i.size());
            pipe.extractor = new TreeSegmentsExtractor[THREADS];
            boolean stack = dis.readBoolean();
            options.featureCreation = dis.readInt();
            int t = 0;
            while (t < THREADS) {
                pipe.extractor[t] = new TreeSegmentsExtractor(this.l2i, stack, options.featureCreation);
                ++t;
            }
            DB.println("Stacking " + stack);
            TreeSegmentsExtractor.initFeatures();
            TreeSegmentsExtractor.initStat(options.featureCreation);
            t = 0;
            while (t < THREADS) {
                pipe.extractor[t].init();
                ++t;
            }
            Edges.read(dis);
            options.decodeProjective = dis.readBoolean();
            TreeSegmentsExtractor.maxForm = dis.readInt();
            boolean foundInfo = false;
            try {
                String info = null;
                int icnt = dis.readInt();
                int i = 0;
                while (i < icnt) {
                    info = dis.readUTF();
                    System.out.println(info);
                    ++i;
                }
            }
            catch (Exception e) {
                if (foundInfo) break block5;
                System.out.println("no info about training");
            }
        }
        dis.close();
        DB.println("Reading data finnished");
        Decoder.NON_PROJECTIVITY_THRESHOLD = (float)options.decodeTH;
        TreeSegmentsExtractor.initStat(options.featureCreation);
    }

    public void train(OptionsSuper options, TreeSegmentsPipe pipe, ParametersFloat params, Instances is, Cluster cluster) throws IOException, InterruptedException, ClassNotFoundException {
        DB.println("\nTraining Information ");
        DB.println("-------------------- ");
        Decoder.NON_PROJECTIVITY_THRESHOLD = (float)options.decodeTH;
        if (options.decodeProjective) {
            System.out.println("Decoding: " + (options.decodeProjective ? "projective" : "non-projective"));
        } else {
            System.out.println(Decoder.getInfo());
        }
        int numInstances = is.size();
        int maxLenInstances = 0;
        int i = 0;
        while (i < numInstances) {
            if (maxLenInstances < is.lengthOfHeads(i)) {
                maxLenInstances = is.lengthOfHeads(i);
            }
            ++i;
        }
        DataFES data = new DataFES(maxLenInstances, pipe.mf.getFeatureCounter().get("REL").shortValue());
        int iter = 0;
        int del = 0;
        float error = 0.0f;
        float f1 = 0.0f;
        FV pred = new FV();
        FV act = new FV();
        double upd = (double)(numInstances * options.numIters) + 1.0;
        while (iter < options.numIters) {
            System.out.print("Iteration " + iter + ": ");
            long start = System.currentTimeMillis();
            long last = System.currentTimeMillis();
            error = 0.0f;
            f1 = 0.0f;
            int n = 0;
            while (n < numInstances) {
                upd -= 1.0;
                if (is.labels[n].length <= options.maxLen) {
                    String info = " td " + (float)Decoder.timeDecotder / 1000000.0f + " tr " + (float)Decoder.timeRearrange / 1000000.0f + " te " + (float)TreeSegmentsPipe.timeExtract / 1000000.0f;
                    if ((n + 1) % 500 == 0) {
                        del = PipeGen.outValueErr(n + 1, error, f1 / (float)n, del, last, upd, info);
                    }
                    short[] pos = is.pposs[n];
                    data = pipe.fillVector(params.getFV(), is, n, data, cluster);
                    short[] headPos = new short[is.heads[n].length];
                    int i2 = 0;
                    while (i2 < headPos.length) {
                        headPos[i2] = is.pposs[n][is.originalPosition[n][i2]];
                        ++i2;
                    }
                    Parse d = Decoder.decode(headPos, data, options.decodeProjective, true);
                    double e = pipe.errors(is, n, d);
                    if (d.f1 > 0.0) {
                        f1 = (float)((double)f1 + d.f1);
                    }
                    if (!(e <= 0.0)) {
                        pred.clear();
                        pipe.extractor[0].encodeCat(is, n, pos, is.forms[n], is.plemmas[n], d.heads, d.labels, is.feats[n], pipe.cl, pred);
                        error = (float)((double)error + e);
                        params.getFV();
                        act.clear();
                        pipe.extractor[0].encodeCat(is, n, pos, is.forms[n], is.plemmas[n], is.heads[n], is.labels[n], is.feats[n], pipe.cl, act);
                        params.update(act, pred, is, n, d, upd, e);
                    }
                }
                ++n;
            }
            String info = " td " + (float)Decoder.timeDecotder / 1000000.0f + " tr " + (float)Decoder.timeRearrange / 1000000.0f + " te " + (float)TreeSegmentsPipe.timeExtract / 1000000.0f + " nz " + params.countNZ();
            PipeGen.outValueErr(numInstances, error, f1 / (float)numInstances, del, last, upd, info);
            del = 0;
            long end = System.currentTimeMillis();
            System.out.println(" time:" + (end - start));
            ParametersFloat pf = params.average2((iter + 1) * is.size());
            try {
                if (options.testfile != null && options.goldfile != null) {
                    this.out(options, pipe, pf, false, false);
                    ParserEvaluator.evaluate(options.goldfile, options.outfile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (error == 0.0f) {
                DB.println("stopped because learned all lessons");
                break;
            }
            Decoder.timeDecotder = 0L;
            Decoder.timeRearrange = 0L;
            TreeSegmentsPipe.timeExtract = 0L;
            ++iter;
        }
        if (options.average) {
            params.average(iter * is.size());
        }
    }

    public void out(OptionsSuper options, TreeSegmentsPipe pipe, ParametersFloat params, boolean maxInfo, boolean labelOnly) throws Exception {
        SentenceData09 instance;
        long start = System.currentTimeMillis();
        CONLLReader09 depReader = options.formatTask == 9 ? new CONLLReader09(options.testfile, options.formatTask) : new CONLLReader08(options.testfile, options.formatTask);
        CONLLWriter09 depWriter = options.formatTask == 9 ? new CONLLWriter09(options.outfile, options.formatTask) : new CONLLWriter08(options.outfile, options.formatTask);
        int cnt = 0;
        int del = 0;
        long last = System.currentTimeMillis();
        if (maxInfo) {
            System.out.println("\nParsing Information ");
        }
        if (maxInfo) {
            System.out.println("------------------- ");
        }
        if (maxInfo && !options.decodeProjective) {
            System.out.println(Decoder.getInfo());
        }
        System.out.print("Processing Sentence: ");
        MoreFeaturesInterface.startReadingAllTest();
        while ((instance = depReader.getNext()) != null) {
            SentenceData09 i09 = this.parse(instance, params, labelOnly, options);
            depWriter.write(i09);
            del = PipeGen.outValue(++cnt, del, last);
        }
        depWriter.finishWriting();
        long end = System.currentTimeMillis();
        if (maxInfo) {
            System.out.println("Used time " + (end - start));
        }
        if (maxInfo) {
            System.out.println("forms count " + Instances.m_count + " unkown " + Instances.m_unkown);
        }
    }

    public SentenceData09 parse(SentenceData09 instance, ParametersFloat params, boolean labelOnly, OptionsSuper options) {
        String[] types = new String[this.pipe.mf.getFeatureCounter().get("REL").intValue()];
        for (Map.Entry<String, Integer> e : MFO.getFeatureSet().get("REL").entrySet()) {
            types[e.getValue().intValue()] = e.getKey();
        }
        this.is = new Instances();
        this.is.init(1, new MFO(), options.formatTask);
        new CONLLReader09().insert(this.is, instance);
        this.is.originalPosition[0] = new int[this.is.length(0)];
        int i = 0;
        while (i < this.is.originalPosition[0].length) {
            this.is.originalPosition[0][i] = i;
            ++i;
        }
        MoreFeaturesInterface.createMoreFeatures(this.is, instance);
        SentenceData09 i09 = new SentenceData09(instance);
        i09.createSemantic(instance);
        if (labelOnly) {
            F2SF f2s = params.getFV();
            this.is.pheads[0] = this.is.heads[0];
            int l = 0;
            while (l < this.is.pheads[0].length) {
                if (this.is.pheads[0][l] < 0) {
                    this.is.pheads[0][l] = 0;
                }
                ++l;
            }
            short[] labels = this.pipe.extractor[0].searchLabel(this.is, 0, this.is.pposs[0], this.is.forms[0], this.is.plemmas[0], this.is.pheads[0], this.is.plabels[0], this.is.feats[0], this.pipe.cl, f2s);
            int j = 0;
            while (j < instance.forms.length - 1) {
                i09.plabels[j] = types[labels[j + 1]];
                i09.pheads[j] = this.is.pheads[0][j + 1];
                ++j;
            }
            return i09;
        }
        if (options.maxLength > instance.length() && options.minLength <= instance.length()) {
            try {
                this.d2 = this.pipe.fillVector(params.getFV(), this.is, 0, null, this.pipe.cl);
                this.d = Decoder.decode(this.is.pposs[0], this.d2, options.decodeProjective, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int j = 0;
            while (j < instance.forms.length - 1) {
                i09.plabels[j] = types[this.d.labels[j + 1]];
                i09.pheads[j] = this.d.heads[j + 1];
                ++j;
            }
        }
        return i09;
    }

    @Override
    public SentenceData09 apply(SentenceData09 snt09) {
        SentenceData09 it = new SentenceData09();
        it.createWithRoot(snt09);
        SentenceData09 out = null;
        try {
            out = this.parse(it, this.params, false, this.options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Decoder.executerService.shutdown();
        TreeSegmentsPipe.executerService.shutdown();
        return out;
    }

    public float[] getInfo() {
        float[] scores = new float[this.is.length(0)];
        TreeSegmentsExtractor.encode3(this.is.pposs[0], this.d.heads, this.d.labels, this.d2, scores);
        return scores;
    }

    public void writeModell(OptionsSuper options, ParametersFloat params, String extension, Cluster cs) throws FileNotFoundException, IOException {
        String name = extension == null ? options.modelName : String.valueOf(options.modelName) + extension;
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(name)));
        zos.putNextEntry(new ZipEntry("data"));
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
        MFO.writeData(dos);
        cs.write(dos);
        params.write(dos);
        dos.writeBoolean(options.stack);
        dos.writeInt(options.featureCreation);
        Edges.write(dos);
        dos.writeBoolean(options.decodeProjective);
        dos.writeInt(TreeSegmentsExtractor.maxForm);
        dos.writeInt(5);
        dos.writeUTF("Used parser   " + TreeSegmentsParser.class.toString());
        dos.writeUTF("Creation date " + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(new Date()));
        dos.writeUTF("Training data " + options.trainfile);
        dos.writeUTF("Iterations    " + options.numIters + " Used sentences " + options.count);
        dos.writeUTF("Cluster       " + options.clusterFile);
        dos.flush();
        dos.close();
    }

    @Override
    public boolean retrain(SentenceData09 sentence, float upd, int iterations) {
        this.params.total = this.params.parameters;
        boolean done = false;
        int k = 0;
        while (k < iterations) {
            try {
                DataFES data = new DataFES(sentence.length(), this.pipe.mf.getFeatureCounter().get("REL").shortValue());
                Instances is = new Instances();
                is.m_encoder = this.pipe.mf;
                is.init(1, this.pipe.mf, this.options.formatTask);
                new CONLLReader09().insert(is, sentence);
                SentenceData09 i09 = new SentenceData09(sentence);
                i09.createSemantic(sentence);
                data = this.pipe.fillVector(this.params.getFV(), is, 0, data, this.pipe.cl);
                short[] pos = is.pposs[0];
                Parse d = Decoder.decode(pos, data, this.options.decodeProjective, true);
                double e = this.pipe.errors(is, 0, d);
                if (e == 0.0) {
                    done = true;
                    break;
                }
                FV pred = new FV();
                this.pipe.extractor[0].encodeCat(is, 0, pos, is.forms[0], is.plemmas[0], d.heads, d.labels, is.feats[0], this.pipe.cl, pred);
                this.params.getFV();
                FV act = new FV();
                this.pipe.extractor[0].encodeCat(is, 0, pos, is.forms[0], is.plemmas[0], is.heads[0], is.labels[0], is.feats[0], this.pipe.cl, act);
                this.params.update(act, pred, is, 0, d, upd, e);
                if (upd > 0.0f) {
                    upd -= 1.0f;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++k;
        }
        Decoder.executerService.shutdown();
        TreeSegmentsPipe.executerService.shutdown();
        return done;
    }

    @Override
    public boolean retrain(SentenceData09 sentence, float upd, int iterations, boolean print) {
        return this.retrain(sentence, upd, iterations);
    }
}

