/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.ListUtils;
import fig.basic.StrUtils;
import fig.basic.Utils;
import fig.record.VarBindingList;
import java.util.List;

public class ArgsParser {
    private char varEscapeChar;
    private String[] names;
    private String[] prevalues;
    private String[] values;
    private List<String> args;

    public ArgsParser(char varEscapeChar, List<String> args) {
        this.varEscapeChar = varEscapeChar;
        this.args = args;
    }

    public ArgsParser setNames(String ... names) {
        if (this.names != null) {
            return this;
        }
        this.names = names;
        this.prevalues = new String[names.length];
        int i = 0;
        while (i < this.args.size()) {
            List<String> kv = StrUtils.splitIgnoreEscaped(this.args.get(i), "=");
            if (kv.size() == 0) {
                this.prevalues[i] = "";
            } else if (kv.size() == 1) {
                this.prevalues[i] = kv.get(0);
            } else {
                this.prevalues[this.getArgIndex((String)kv.get((int)0))] = kv.get(1);
            }
            ++i;
        }
        return this;
    }

    private int getArgIndex(String name) {
        int i = 0;
        while (i < this.names.length) {
            if (this.names[i].equals(name)) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Unknown name: " + name);
    }

    public void parse(VarBindingList bindings) {
        this.values = this.names == null ? ListUtils.stringToArray(this.args) : (String[])this.prevalues.clone();
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = bindings.substitute(this.values[i]);
            this.values[i] = ArgsParser.unescape(this.values[i]);
            ++i;
        }
    }

    public static String unescape(String s, char exceptChar) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean escape = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (escape) {
                buf.append(c);
                escape = false;
            } else if (c == '\\' && (i + 1 >= s.length() || s.charAt(i + 1) != exceptChar)) {
                escape = true;
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String unescape(String s) {
        return ArgsParser.unescape(s, '\u0000');
    }

    public int size() {
        return this.values.length;
    }

    public RuntimeException badArg(int i) {
        return new RuntimeException(String.format("Bad index: %d, names = %s", i, StrUtils.join(this.names)));
    }

    public String get(int i, String defValue) {
        return this.values[i] == null ? defValue : this.values[i];
    }

    public String get(String var, String defValue) {
        return this.get(this.getArgIndex(var), defValue);
    }

    public int getInt(int i, int defValue) {
        return Utils.parseIntEasy(this.get(i, null), defValue);
    }

    public int getInt(String var, int defValue) {
        return this.getInt(this.getArgIndex(var), defValue);
    }

    public boolean getBoolean(int i, boolean defValue) {
        return Utils.parseBooleanEasy(this.get(i, null), defValue);
    }

    public boolean getBoolean(String var, boolean defValue) {
        return this.getBoolean(this.getArgIndex(var), defValue);
    }

    public double getDouble(int i, double defValue) {
        return Utils.parseDoubleEasy(this.get(i, null), defValue);
    }

    public double getDouble(String var, double defValue) {
        return this.getDouble(this.getArgIndex(var), defValue);
    }

    public String getHard(int i) {
        if (this.values[i] == null) {
            throw this.badArg(i);
        }
        return this.values[i];
    }

    public String getHard(String var) {
        return this.getHard(this.getArgIndex(var));
    }

    public int getIntHard(int i) {
        return Utils.parseIntHard(this.get(i, null));
    }

    public int getIntHard(String var) {
        return this.getIntHard(this.getArgIndex(var));
    }

    public boolean getBooleanHard(int i) {
        return Utils.parseBooleanHard(this.get(i, null));
    }

    public boolean getBooleanHard(String var) {
        return this.getBooleanHard(this.getArgIndex(var));
    }

    public double getDoubleHard(int i) {
        return Utils.parseDoubleHard(this.get(i, null));
    }

    public double getDoubleHard(String var) {
        return this.getDoubleHard(this.getArgIndex(var));
    }
}

