/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.parserR2;

import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import matetools.decoder.ParallelDecoder;
import matetools.decoder.ParallelRearrangeNBest;
import matetools.decoder.ParallelRearrangeNBest2;
import matetools.extractors.Extractor;
import matetools.is2.data.Closed;
import matetools.is2.data.DataF;
import matetools.is2.data.Instances;
import matetools.is2.data.Open;
import matetools.is2.data.Parse;
import matetools.is2.data.ParseNBest;
import matetools.is2.parserR2.Parser;

public final class Decoder {
    public static final boolean TRAINING = true;
    public static long timeDecotder;
    public static long timeRearrange;
    public static final boolean LAS = true;
    public static float NON_PROJECTIVITY_THRESHOLD;
    public static ExecutorService executerService;
    static Parse bestProj;

    static {
        NON_PROJECTIVITY_THRESHOLD = 0.3f;
        executerService = Executors.newFixedThreadPool(Parser.THREADS);
        bestProj = null;
    }

    private Decoder() {
    }

    public static List<ParseNBest> decode(short[] pos, DataF x, boolean projective, Extractor extractor) throws InterruptedException {
        ArrayList<ParseNBest> parses;
        long ts = System.nanoTime();
        if (executerService.isShutdown()) {
            executerService = Executors.newCachedThreadPool();
        }
        int n = pos.length;
        Open[][][][] O = new Open[n][n][2][];
        Closed[][][][] C2 = new Closed[n][n][2][];
        ArrayList<ParallelDecoder> pe = new ArrayList<ParallelDecoder>();
        int i = 0;
        while (i < Parser.THREADS) {
            pe.add(new ParallelDecoder(pos, x, O, C2, n));
            ++i;
        }
        int k = 1;
        while (k < n) {
            int s = 0;
            while (s < n) {
                short t = (short)(s + k);
                if (t >= n) break;
                ParallelDecoder.add((short)s, t);
                s = (short)(s + 1);
            }
            executerService.invokeAll(pe);
            k = (short)(k + 1);
        }
        double bestSpanScore = Double.NEGATIVE_INFINITY;
        Closed bestSpan = null;
        int m = 1;
        while (m < n) {
            if (C2[0][n - 1][1][m].p > bestSpanScore) {
                bestSpanScore = C2[0][n - 1][1][m].p;
                bestSpan = C2[0][n - 1][1][m];
            }
            ++m;
        }
        ParseNBest out = new ParseNBest(pos.length);
        bestSpan.create(out);
        out.heads[0] = -1;
        out.labels[0] = 0;
        bestProj = out;
        timeDecotder += System.nanoTime() - ts;
        ts = System.nanoTime();
        if (!projective) {
            parses = Decoder.rearrangeNBest(pos, out.heads, out.labels, x, extractor);
        } else {
            parses = new ArrayList<ParseNBest>();
            parses.add(out);
        }
        timeRearrange += System.nanoTime() - ts;
        return parses;
    }

    /*
     * Unable to fully structure code
     */
    public static List<ParseNBest> rearrangeNBestP(short[] pos, short[] heads, short[] labs, DataF x, Extractor extractor) throws InterruptedException {
        pe = new ArrayList<ParallelRearrangeNBest2>();
        round = 0;
        parses = new ArrayList<ParseNBest>();
        px = new ParseNBest();
        px.signature(heads, labs);
        px.f1 = extractor.encode3(pos, heads, labs, x);
        parses.add(px);
        lastNBest = -Infinityf;
        done = new HashSet<ParseNBest>();
        contained = new THashSet();
        while (true) {
            pe.clear();
            ic = 0;
            considered = 0;
            while (parses.size() > ic && considered <= 11) {
                parse = (ParseNBest)parses.get(ic);
                ++ic;
                if (done.contains(parse)) continue;
                ++considered;
                parse.signature2parse(parse.signature());
                done.add(parse);
                isChild = new boolean[heads.length][heads.length];
                i = 1;
                l1 = 1;
                ** GOTO lbl33
                {
                    isChild[l1][i] = true;
                    do {
                        if ((l1 = heads[l1]) != -1) continue block2;
                        l1 = ++i;
lbl33:
                        // 2 sources

                    } while (i < heads.length);
                }
                ch = 1;
                while (ch < heads.length) {
                    pa = 0;
                    while (pa < heads.length) {
                        if (ch != pa && pa != heads[ch] && !isChild[ch][pa]) {
                            ParallelRearrangeNBest2.add(parse.clone(), ch, pa);
                        }
                        pa = (short)(pa + 1);
                    }
                    ch = (short)(ch + 1);
                }
            }
            t = 0;
            while (t < Parser.THREADS) {
                pe.add(new ParallelRearrangeNBest2(pos, x, lastNBest, extractor, Decoder.NON_PROJECTIVITY_THRESHOLD));
                ++t;
            }
            Decoder.executerService.invokeAll(pe);
            for (ParallelRearrangeNBest2 rp : pe) {
                k = rp.parses.size() - 1;
                while (k >= 0) {
                    if (!((double)lastNBest > rp.parses.get((int)k).f1) && !contained.contains((Object)(sig = rp.parses.get(k).signature()))) {
                        parses.add(rp.parses.get(k));
                        contained.add((Object)sig);
                    }
                    --k;
                }
            }
            Collections.sort(parses);
            if (round >= 2) break;
            ++round;
            if (parses.size() <= Parser.NBest) continue;
            parses.subList(Parser.NBest, parses.size() - 1).clear();
        }
        return parses;
    }

    public static List<ParseNBest> rearrangeNBest(short[] pos, short[] heads, short[] labs, DataF x, Extractor extractor) throws InterruptedException {
        ArrayList<ParallelRearrangeNBest> pe = new ArrayList<ParallelRearrangeNBest>();
        int round = 0;
        ArrayList<ParseNBest> parses = new ArrayList<ParseNBest>();
        ParseNBest px = new ParseNBest();
        px.signature(heads, labs);
        px.f1 = extractor.encode3(pos, heads, labs, x);
        parses.add(px);
        float lastNBest = Float.NEGATIVE_INFINITY;
        HashSet<ParseNBest> done = new HashSet<ParseNBest>();
        THashSet contained = new THashSet();
        while (true) {
            pe.clear();
            for (int i = 0; parses.size() > i && pe.size() <= 12; ++i) {
                ParseNBest parse = (ParseNBest)parses.get(i);
                if (done.contains(parse)) continue;
                parse.signature2parse(parse.signature());
                done.add(parse);
                pe.add(new ParallelRearrangeNBest(pos, x, parse, lastNBest, extractor, (float)parse.f1, NON_PROJECTIVITY_THRESHOLD));
            }
            executerService.invokeAll(pe);
            for (ParallelRearrangeNBest rp : pe) {
                int k = rp.parses.size() - 1;
                while (k >= 0) {
                    String sig;
                    if (!((double)lastNBest > rp.parses.get((int)k).f1) && !contained.contains((Object)(sig = rp.parses.get(k).signature()))) {
                        parses.add(rp.parses.get(k));
                        contained.add((Object)sig);
                    }
                    --k;
                }
            }
            Collections.sort(parses);
            if (round >= 2) break;
            ++round;
            if (parses.size() <= Parser.NBest) continue;
            if (parses.get((int)Parser.NBest).f1 > (double)lastNBest) {
                lastNBest = (float)parses.get((int)Parser.NBest).f1;
            }
            parses.subList(Parser.NBest, parses.size() - 1).clear();
        }
        return parses;
    }

    public static String getInfo() {
        return "Decoder non-projectivity threshold: " + NON_PROJECTIVITY_THRESHOLD;
    }

    public static int getGoldRank(List<ParseNBest> parses, Instances is, int i, boolean las) {
        int p = 0;
        while (p < parses.size()) {
            if (parses.get((int)p).heads == null) {
                parses.get(p).signature2parse(parses.get(p).signature());
            }
            boolean eq = true;
            int w = 1;
            while (w < is.length(0)) {
                if (is.heads[i][w] != parses.get((int)p).heads[w] || is.labels[i][w] != parses.get((int)p).labels[w] && las) {
                    eq = false;
                    break;
                }
                ++w;
            }
            if (eq) {
                return p;
            }
            ++p;
        }
        return -1;
    }

    public static int getSmallestError(List<ParseNBest> parses, Instances is, int i, boolean las) {
        int smallest = -1;
        int p = 0;
        while (p < parses.size()) {
            int err = 0;
            int w = 1;
            while (w < is.length(0)) {
                if (is.heads[i][w] != parses.get((int)p).heads[w] || is.labels[i][w] != parses.get((int)p).labels[w] && las) {
                    ++err;
                }
                ++w;
            }
            if (smallest == -1 || smallest > err) {
                smallest = err;
            }
            if (smallest == 0) {
                return 0;
            }
            ++p;
        }
        return smallest;
    }

    public static int getError(ParseNBest parse, Instances is, int i, boolean las) {
        int err = 0;
        int w = 1;
        while (w < is.length(i)) {
            if (is.heads[i][w] != parse.heads[w] || is.labels[i][w] != parse.labels[w] && las) {
                ++err;
            }
            ++w;
        }
        return err;
    }
}

