/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.record.LeafRecordNode;
import fig.record.RecordNode;
import fig.record.RecordNodeUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRecordNode
implements RecordNode {
    private final String key;
    private final String value;

    public AbstractRecordNode(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return RecordNodeUtils.getDoubleValue(this);
    }

    @Override
    public String getDescription(RecordNode.DescriptionType type) {
        return RecordNodeUtils.getDescription(this.getKey(), this.getValue(), type);
    }

    @Override
    public List<RecordNode> getChildren(String key) {
        ArrayList<RecordNode> matchedChildren = new ArrayList<RecordNode>();
        for (RecordNode child : this.getChildren()) {
            if (!child.getKey().equals(key)) continue;
            matchedChildren.add(child);
        }
        return matchedChildren;
    }

    @Override
    public int numChildren() {
        return this.getChildren().size();
    }

    @Override
    public int numChildren(String key) {
        return this.getChildren(key).size();
    }

    public String toString() {
        return this.getDescription(RecordNode.DescriptionType.human);
    }

    @Override
    public RecordNode withoutChildren() {
        return new LeafRecordNode(this.getKey(), this.getValue());
    }
}

