/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.Exceptions;
import fig.basic.ListUtils;
import fig.basic.MapUtils;
import fig.basic.NumUtils;
import fig.basic.StrUtils;
import fig.basic.TDoubleMap;
import java.text.SimpleDateFormat;

public class Fmt {
    public static String D(double x) {
        if (Math.abs(x - (double)((int)x)) < 1.0E-40) {
            return "" + (int)x;
        }
        if (Math.abs(x) < 0.001) {
            return String.format("%.2e", x);
        }
        return String.format("%.3f", x);
    }

    public static String D(boolean[] x) {
        return StrUtils.join(x);
    }

    public static String D(int[] x) {
        return StrUtils.join(x);
    }

    public static String D(double[] x) {
        return Fmt.D(x, " ");
    }

    public static String D(double[] xs, String delim) {
        StringBuilder sb = new StringBuilder();
        double[] dArray = xs;
        int n = xs.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(Fmt.D(x));
            ++n2;
        }
        return sb.toString();
    }

    public static String D(double[] x, int firstN) {
        if (firstN >= x.length) {
            return Fmt.D(x);
        }
        return String.valueOf(Fmt.D(ListUtils.subArray(x, 0, firstN))) + " ...(" + (x.length - firstN) + " more)";
    }

    public static String D(double[][] x) {
        return Fmt.D(x, " ");
    }

    public static String D(double[][] xs, String delim) {
        StringBuilder sb = new StringBuilder();
        double[][] dArray = xs;
        int n = xs.length;
        int n2 = 0;
        while (n2 < n) {
            double[] x = dArray[n2];
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(Fmt.D(x));
            ++n2;
        }
        return sb.toString();
    }

    public static String D(TDoubleMap map) {
        return Fmt.D(map, 20);
    }

    public static String D(TDoubleMap map, int numTop) {
        return MapUtils.topNToString(map, numTop);
    }

    public static String D(Object o) {
        if (o instanceof double[]) {
            return Fmt.D((double[])o);
        }
        if (o instanceof double[][]) {
            return Fmt.D((double[][])o);
        }
        if (o instanceof double[][][]) {
            return Fmt.D((double[][][])o);
        }
        throw Exceptions.unknownCase;
    }

    public static String bytesToString(long b) {
        double gb = (double)b / 1.073741824E9;
        if (gb >= 1.0) {
            return gb >= 10.0 ? String.valueOf((int)gb) + "G" : String.valueOf(NumUtils.round(gb, 1)) + "G";
        }
        double mb = (double)b / 1048576.0;
        if (mb >= 1.0) {
            return mb >= 10.0 ? String.valueOf((int)mb) + "M" : String.valueOf(NumUtils.round(mb, 1)) + "M";
        }
        double kb = (double)b / 1024.0;
        if (kb >= 1.0) {
            return kb >= 10.0 ? String.valueOf((int)kb) + "K" : String.valueOf(NumUtils.round(kb, 1)) + "K";
        }
        return String.valueOf(b);
    }

    public static String formatEasyDateTime(long t) {
        return new SimpleDateFormat("MM/dd HH:mm").format(t);
    }
}

