/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.io.dataformat;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.io.dataformat.ColumnDescription;
import org.maltparser.core.io.dataformat.DataFormatEntry;
import org.maltparser.core.io.dataformat.DataFormatSpecification;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.SymbolTableHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFormatInstance
implements Iterable<ColumnDescription> {
    private final SortedSet<ColumnDescription> columnDescriptions = new TreeSet<ColumnDescription>();
    private SortedMap<String, ColumnDescription> headColumnDescriptions;
    private SortedMap<String, ColumnDescription> dependencyEdgeLabelColumnDescriptions;
    private SortedMap<String, ColumnDescription> phraseStructureEdgeLabelColumnDescriptions;
    private SortedMap<String, ColumnDescription> phraseStructureNodeLabelColumnDescriptions;
    private SortedMap<String, ColumnDescription> secondaryEdgeLabelColumnDescriptions;
    private SortedMap<String, ColumnDescription> inputColumnDescriptions;
    private SortedMap<String, ColumnDescription> ignoreColumnDescriptions;
    private SortedSet<ColumnDescription> headColumnDescriptionSet;
    private SortedSet<ColumnDescription> dependencyEdgeLabelColumnDescriptionSet;
    private SortedSet<ColumnDescription> phraseStructureEdgeLabelColumnDescriptionSet;
    private SortedSet<ColumnDescription> phraseStructureNodeLabelColumnDescriptionSet;
    private SortedSet<ColumnDescription> secondaryEdgeLabelColumnDescriptionSet;
    private SortedSet<ColumnDescription> inputColumnDescriptionSet;
    private SortedSet<ColumnDescription> ignoreColumnDescriptionSet;
    private SortedMap<String, SymbolTable> dependencyEdgeLabelSymbolTables;
    private SortedMap<String, SymbolTable> phraseStructureEdgeLabelSymbolTables;
    private SortedMap<String, SymbolTable> phraseStructureNodeLabelSymbolTables;
    private SortedMap<String, SymbolTable> secondaryEdgeLabelSymbolTables;
    private SortedMap<String, SymbolTable> inputSymbolTables;
    private SymbolTableHandler symbolTables;
    private DataFormatSpecification dataFormarSpec;

    public DataFormatInstance(SortedMap<String, DataFormatEntry> entries, SymbolTableHandler symbolTables, String nullValueStrategy, String rootLabel, DataFormatSpecification spec) throws MaltChainedException {
        this.symbolTables = symbolTables;
        this.createColumnDescriptions(entries, nullValueStrategy, rootLabel);
        this.setDataFormarSpec(spec);
    }

    private void createColumnDescriptions(SortedMap<String, DataFormatEntry> entries, String nullValueStrategy, String rootLabel) throws MaltChainedException {
        for (DataFormatEntry entry : entries.values()) {
            this.columnDescriptions.add(new ColumnDescription(entry.getPosition(), entry.getDataFormatEntryName(), entry.getCategory(), entry.getType(), entry.getDefaultOutput(), this.symbolTables, nullValueStrategy, rootLabel));
        }
    }

    public ColumnDescription getColumnDescriptionByName(String name) {
        for (ColumnDescription column : this.columnDescriptions) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public int getNumberOfColumnDescriptions() {
        return this.columnDescriptions.size();
    }

    @Override
    public Iterator<ColumnDescription> iterator() {
        return this.columnDescriptions.iterator();
    }

    public DataFormatSpecification getDataFormarSpec() {
        return this.dataFormarSpec;
    }

    private void setDataFormarSpec(DataFormatSpecification dataFormarSpec) {
        this.dataFormarSpec = dataFormarSpec;
    }

    protected void createHeadColumnDescriptions() {
        this.headColumnDescriptions = new TreeMap<String, ColumnDescription>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getCategory() != 2 || column.getType() == 5) continue;
            this.headColumnDescriptions.put(column.getName(), column);
        }
    }

    public ColumnDescription getHeadColumnDescription() {
        if (this.headColumnDescriptions == null) {
            this.createHeadColumnDescriptions();
        }
        return (ColumnDescription)this.headColumnDescriptions.get(this.headColumnDescriptions.firstKey());
    }

    public SortedMap<String, ColumnDescription> getHeadColumnDescriptions() {
        if (this.headColumnDescriptions == null) {
            this.createHeadColumnDescriptions();
        }
        return this.headColumnDescriptions;
    }

    protected void createDependencyEdgeLabelSymbolTables() {
        this.dependencyEdgeLabelSymbolTables = new TreeMap<String, SymbolTable>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getCategory() != 3 || column.getType() == 5) continue;
            this.dependencyEdgeLabelSymbolTables.put(column.getSymbolTable().getName(), column.getSymbolTable());
        }
    }

    public SortedMap<String, SymbolTable> getDependencyEdgeLabelSymbolTables() {
        if (this.dependencyEdgeLabelSymbolTables == null) {
            this.createDependencyEdgeLabelSymbolTables();
        }
        return this.dependencyEdgeLabelSymbolTables;
    }

    protected void createDependencyEdgeLabelColumnDescriptions() {
        this.dependencyEdgeLabelColumnDescriptions = new TreeMap<String, ColumnDescription>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getCategory() != 3 || column.getType() == 5) continue;
            this.dependencyEdgeLabelColumnDescriptions.put(column.getName(), column);
        }
    }

    public SortedMap<String, ColumnDescription> getDependencyEdgeLabelColumnDescriptions() {
        if (this.dependencyEdgeLabelColumnDescriptions == null) {
            this.createDependencyEdgeLabelColumnDescriptions();
        }
        return this.dependencyEdgeLabelColumnDescriptions;
    }

    protected void createPhraseStructureEdgeLabelSymbolTables() {
        this.phraseStructureEdgeLabelSymbolTables = new TreeMap<String, SymbolTable>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getCategory() != 4 || column.getType() == 5) continue;
            this.phraseStructureEdgeLabelSymbolTables.put(column.getSymbolTable().getName(), column.getSymbolTable());
        }
    }

    public SortedMap<String, SymbolTable> getPhraseStructureEdgeLabelSymbolTables() {
        if (this.phraseStructureEdgeLabelSymbolTables == null) {
            this.createPhraseStructureEdgeLabelSymbolTables();
        }
        return this.phraseStructureEdgeLabelSymbolTables;
    }

    protected void createPhraseStructureEdgeLabelColumnDescriptions() {
        this.phraseStructureEdgeLabelColumnDescriptions = new TreeMap<String, ColumnDescription>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getCategory() != 4 || column.getType() == 5) continue;
            this.phraseStructureEdgeLabelColumnDescriptions.put(column.getName(), column);
        }
    }

    public SortedMap<String, ColumnDescription> getPhraseStructureEdgeLabelColumnDescriptions() {
        if (this.phraseStructureEdgeLabelColumnDescriptions == null) {
            this.createPhraseStructureEdgeLabelColumnDescriptions();
        }
        return this.phraseStructureEdgeLabelColumnDescriptions;
    }

    protected void createPhraseStructureNodeLabelSymbolTables() {
        this.phraseStructureNodeLabelSymbolTables = new TreeMap<String, SymbolTable>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getCategory() != 5 || column.getType() == 5) continue;
            this.phraseStructureNodeLabelSymbolTables.put(column.getSymbolTable().getName(), column.getSymbolTable());
        }
    }

    public SortedMap<String, SymbolTable> getPhraseStructureNodeLabelSymbolTables() {
        if (this.phraseStructureNodeLabelSymbolTables == null) {
            this.createPhraseStructureNodeLabelSymbolTables();
        }
        return this.phraseStructureNodeLabelSymbolTables;
    }

    protected void createPhraseStructureNodeLabelColumnDescriptions() {
        this.phraseStructureNodeLabelColumnDescriptions = new TreeMap<String, ColumnDescription>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getCategory() != 5 || column.getType() == 5) continue;
            this.phraseStructureNodeLabelColumnDescriptions.put(column.getName(), column);
        }
    }

    public SortedMap<String, ColumnDescription> getPhraseStructureNodeLabelColumnDescriptions() {
        if (this.phraseStructureNodeLabelColumnDescriptions == null) {
            this.createPhraseStructureNodeLabelColumnDescriptions();
        }
        return this.phraseStructureNodeLabelColumnDescriptions;
    }

    protected void createSecondaryEdgeLabelSymbolTables() {
        this.secondaryEdgeLabelSymbolTables = new TreeMap<String, SymbolTable>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getCategory() != 4 || column.getType() == 5) continue;
            this.secondaryEdgeLabelSymbolTables.put(column.getSymbolTable().getName(), column.getSymbolTable());
        }
    }

    public SortedMap<String, SymbolTable> getSecondaryEdgeLabelSymbolTables() {
        if (this.secondaryEdgeLabelSymbolTables == null) {
            this.createSecondaryEdgeLabelSymbolTables();
        }
        return this.secondaryEdgeLabelSymbolTables;
    }

    protected void createSecondaryEdgeLabelColumnDescriptions() {
        this.secondaryEdgeLabelColumnDescriptions = new TreeMap<String, ColumnDescription>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getCategory() != 4 || column.getType() == 5) continue;
            this.secondaryEdgeLabelColumnDescriptions.put(column.getName(), column);
        }
    }

    public SortedMap<String, ColumnDescription> getSecondaryEdgeLabelColumnDescriptions() {
        if (this.secondaryEdgeLabelColumnDescriptions == null) {
            this.createSecondaryEdgeLabelColumnDescriptions();
        }
        return this.secondaryEdgeLabelColumnDescriptions;
    }

    protected void createInputSymbolTables() {
        this.inputSymbolTables = new TreeMap<String, SymbolTable>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getCategory() != 1 || column.getType() == 5) continue;
            this.inputSymbolTables.put(column.getSymbolTable().getName(), column.getSymbolTable());
        }
    }

    public SortedMap<String, SymbolTable> getInputSymbolTables() {
        if (this.inputSymbolTables == null) {
            this.createInputSymbolTables();
        }
        return this.inputSymbolTables;
    }

    protected void createInputColumnDescriptions() {
        this.inputColumnDescriptions = new TreeMap<String, ColumnDescription>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getCategory() != 1 || column.getType() == 5) continue;
            this.inputColumnDescriptions.put(column.getName(), column);
        }
    }

    public SortedMap<String, ColumnDescription> getInputColumnDescriptions() {
        if (this.inputColumnDescriptions == null) {
            this.createInputColumnDescriptions();
        }
        return this.inputColumnDescriptions;
    }

    protected void createIgnoreColumnDescriptions() {
        this.ignoreColumnDescriptions = new TreeMap<String, ColumnDescription>();
        for (ColumnDescription column : this.columnDescriptions) {
            if (column.getType() != 5) continue;
            this.ignoreColumnDescriptions.put(column.getName(), column);
        }
    }

    public SortedMap<String, ColumnDescription> getIgnoreColumnDescriptions() {
        if (this.ignoreColumnDescriptions == null) {
            this.createIgnoreColumnDescriptions();
        }
        return this.ignoreColumnDescriptions;
    }

    public SortedSet<ColumnDescription> getHeadColumnDescriptionSet() {
        if (this.headColumnDescriptionSet == null) {
            this.headColumnDescriptionSet = new TreeSet<ColumnDescription>();
            for (ColumnDescription column : this.columnDescriptions) {
                if (column.getCategory() != 2 || column.getType() == 5) continue;
                this.headColumnDescriptionSet.add(column);
            }
        }
        return this.headColumnDescriptionSet;
    }

    public SortedSet<ColumnDescription> getDependencyEdgeLabelColumnDescriptionSet() {
        if (this.dependencyEdgeLabelColumnDescriptionSet == null) {
            this.dependencyEdgeLabelColumnDescriptionSet = new TreeSet<ColumnDescription>();
            for (ColumnDescription column : this.columnDescriptions) {
                if (column.getCategory() != 3 || column.getType() == 5) continue;
                this.dependencyEdgeLabelColumnDescriptionSet.add(column);
            }
        }
        return this.dependencyEdgeLabelColumnDescriptionSet;
    }

    public SortedSet<ColumnDescription> getPhraseStructureEdgeLabelColumnDescriptionSet() {
        if (this.phraseStructureEdgeLabelColumnDescriptionSet == null) {
            this.phraseStructureEdgeLabelColumnDescriptionSet = new TreeSet<ColumnDescription>();
            for (ColumnDescription column : this.columnDescriptions) {
                if (column.getCategory() != 4 || column.getType() == 5) continue;
                this.phraseStructureEdgeLabelColumnDescriptionSet.add(column);
            }
        }
        return this.phraseStructureEdgeLabelColumnDescriptionSet;
    }

    public SortedSet<ColumnDescription> getPhraseStructureNodeLabelColumnDescriptionSet() {
        if (this.phraseStructureNodeLabelColumnDescriptionSet == null) {
            this.phraseStructureNodeLabelColumnDescriptionSet = new TreeSet<ColumnDescription>();
            for (ColumnDescription column : this.columnDescriptions) {
                if (column.getCategory() != 5 || column.getType() == 5) continue;
                this.phraseStructureNodeLabelColumnDescriptionSet.add(column);
            }
        }
        return this.phraseStructureNodeLabelColumnDescriptionSet;
    }

    public SortedSet<ColumnDescription> getSecondaryEdgeLabelColumnDescriptionSet() {
        if (this.secondaryEdgeLabelColumnDescriptionSet == null) {
            this.secondaryEdgeLabelColumnDescriptionSet = new TreeSet<ColumnDescription>();
            for (ColumnDescription column : this.columnDescriptions) {
                if (column.getCategory() != 6 || column.getType() == 5) continue;
                this.secondaryEdgeLabelColumnDescriptionSet.add(column);
            }
        }
        return this.secondaryEdgeLabelColumnDescriptionSet;
    }

    public SortedSet<ColumnDescription> getInputColumnDescriptionSet() {
        if (this.inputColumnDescriptionSet == null) {
            this.inputColumnDescriptionSet = new TreeSet<ColumnDescription>();
            for (ColumnDescription column : this.columnDescriptions) {
                if (column.getCategory() != 1 || column.getType() == 5) continue;
                this.inputColumnDescriptionSet.add(column);
            }
        }
        return this.inputColumnDescriptionSet;
    }

    public SortedSet<ColumnDescription> getIgnoreColumnDescriptionSet() {
        if (this.ignoreColumnDescriptionSet == null) {
            this.ignoreColumnDescriptionSet = new TreeSet<ColumnDescription>();
            for (ColumnDescription column : this.columnDescriptions) {
                if (column.getType() != 5) continue;
                this.ignoreColumnDescriptionSet.add(column);
            }
        }
        return this.ignoreColumnDescriptionSet;
    }

    public SymbolTableHandler getSymbolTables() {
        return this.symbolTables;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ColumnDescription column : this.columnDescriptions) {
            sb.append(column);
            sb.append('\n');
        }
        return sb.toString();
    }
}

