/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SmallObjectToDoubleMap<E extends Comparable<E>>
extends AbstractMap<E, Double>
implements Serializable {
    static final long serialVersionUID = -2767319214600216544L;
    final E[] mKeys;
    final double[] mValues;

    public SmallObjectToDoubleMap(Map<E, ? extends Number> map) {
        Comparable[] tempKeys = new Comparable[map.size()];
        this.mKeys = tempKeys;
        map.keySet().toArray(this.mKeys);
        Arrays.sort(this.mKeys);
        this.mValues = new double[this.mKeys.length];
        for (int i = 0; i < this.mKeys.length; ++i) {
            this.mValues[i] = map.get(this.mKeys[i]).doubleValue();
        }
    }

    SmallObjectToDoubleMap(E[] keys, double[] values) {
        this.mKeys = keys;
        this.mValues = values;
    }

    public double getValue(E key) {
        int index = Arrays.binarySearch(this.mKeys, key);
        return index < 0 ? 0.0 : this.mValues[index];
    }

    @Override
    public Set<Map.Entry<E, Double>> entrySet() {
        return new EntrySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return Arrays.binarySearch(this.mKeys, key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        double val = (Double)value;
        for (int i = 0; i < this.mValues.length; ++i) {
            if (val != this.mValues[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        int i = Arrays.binarySearch(this.mKeys, key);
        return i < 0 ? null : Double.valueOf(this.mValues[i]);
    }

    @Override
    public int size() {
        return this.mKeys.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public double dotProduct(SmallObjectToDoubleMap<E> that) {
        double sum = 0.0;
        int i = 0;
        int j = 0;
        while (i < this.mKeys.length && j < that.mKeys.length) {
            int comp = this.mKeys[i].compareTo(that.mKeys[j]);
            if (comp == 0) {
                sum += this.mValues[i++] * that.mValues[j++];
                continue;
            }
            if (comp < 0) {
                ++i;
                continue;
            }
            ++j;
        }
        return sum;
    }

    public SmallObjectToDoubleMap<E> multiply(double x) {
        double[] values = new double[this.mValues.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = x * this.mValues[i];
        }
        return new SmallObjectToDoubleMap(this.mKeys, values);
    }

    private Object writeReplace() {
        return new Externalizer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Externalizer<F extends Comparable<F>>
    extends AbstractExternalizable {
        static final long serialVersionUID = 4630833136856570210L;
        final SmallObjectToDoubleMap<F> mMap;

        public Externalizer() {
            this(null);
        }

        public Externalizer(SmallObjectToDoubleMap<F> map) {
            this.mMap = map;
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            int len = in.readInt();
            Comparable[] keys = new Comparable[len];
            for (int i = 0; i < len; ++i) {
                Comparable tempF;
                keys[i] = tempF = (Comparable)in.readObject();
            }
            double[] values = new double[len];
            for (int i = 0; i < len; ++i) {
                values[i] = in.readDouble();
            }
            return new SmallObjectToDoubleMap(keys, values);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            int i;
            out.writeInt(this.mMap.mKeys.length);
            for (i = 0; i < this.mMap.mKeys.length; ++i) {
                AbstractExternalizable.compileOrSerialize(this.mMap.mKeys[i], out);
            }
            for (i = 0; i < this.mMap.mValues.length; ++i) {
                out.writeDouble(this.mMap.mValues[i]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry
    implements Map.Entry<E, Double> {
        private final int mIndex;

        Entry(int index) {
            this.mIndex = index;
        }

        @Override
        public E getKey() {
            return SmallObjectToDoubleMap.this.mKeys[this.mIndex];
        }

        @Override
        public Double getValue() {
            return SmallObjectToDoubleMap.this.mValues[this.mIndex];
        }

        @Override
        public Double setValue(Double value) {
            String msg = "Not modifiable.";
            throw new UnsupportedOperationException(msg);
        }

        @Override
        public boolean equals(Object that) {
            if (!(that instanceof Map.Entry)) {
                return false;
            }
            Map.Entry thatEntry = (Map.Entry)that;
            return (this.getKey() == null ? thatEntry.getKey() == null : this.getKey().equals(thatEntry.getKey())) && (this.getValue() == null ? thatEntry.getValue() == null : this.getValue().equals(thatEntry.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryIterator
    implements Iterator<Map.Entry<E, Double>> {
        private int mNext = 0;

        EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mNext < SmallObjectToDoubleMap.this.mKeys.length;
        }

        @Override
        public Map.Entry<E, Double> next() {
            if (!this.hasNext()) {
                String msg = "No more elements in iterator.";
                throw new NoSuchElementException(msg);
            }
            return new Entry(this.mNext++);
        }

        @Override
        public void remove() {
            String msg = "Removal not supported.";
            throw new UnsupportedOperationException(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntrySet
    extends AbstractSet<Map.Entry<E, Double>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return SmallObjectToDoubleMap.this.mKeys.length;
        }

        @Override
        public Iterator<Map.Entry<E, Double>> iterator() {
            return new EntryIterator();
        }
    }
}

