/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.ModifiedTokenizerFactory;
import com.aliasi.tokenizer.ModifyTokenTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.regex.Pattern;

public class RegExFilteredTokenizerFactory
extends ModifyTokenTokenizerFactory
implements Serializable {
    static final long serialVersionUID = -288230238413152431L;
    private final Pattern mPattern;

    public RegExFilteredTokenizerFactory(TokenizerFactory factory, Pattern pattern) {
        super(factory);
        this.mPattern = pattern;
    }

    public String modifyToken(String token) {
        return this.mPattern.matcher(token).matches() ? token : null;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Serializer
    extends ModifiedTokenizerFactory.AbstractSerializer<RegExFilteredTokenizerFactory> {
        static final long serialVersionUID = -9179825153562519026L;

        public Serializer() {
            this(null);
        }

        public Serializer(RegExFilteredTokenizerFactory factory) {
            super(factory);
        }

        @Override
        public void writeExternalRest(ObjectOutput out) throws IOException {
            out.writeObject(((RegExFilteredTokenizerFactory)this.factory()).mPattern);
        }

        @Override
        public Object read(ObjectInput in, TokenizerFactory baseFactory) throws IOException, ClassNotFoundException {
            Pattern pattern = (Pattern)in.readObject();
            return new RegExFilteredTokenizerFactory(baseFactory, pattern);
        }
    }
}

