/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.AbstractVector;
import com.aliasi.matrix.Matrices;
import com.aliasi.matrix.Vector;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFloatVector
extends AbstractVector
implements Serializable {
    static final long serialVersionUID = -6258691051932319575L;
    final int[] mKeys;
    final float[] mValues;
    final int mNumDimensions;
    final double mLength;
    static final Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];

    public SparseFloatVector(Map<Integer, ? extends Number> map) {
        this(map, -1, false);
    }

    public SparseFloatVector(Map<Integer, ? extends Number> map, int numDimensions) {
        this(map, numDimensions, true);
    }

    public SparseFloatVector(int[] keys, float[] values, int numDimensions) {
        this(keys, values, numDimensions, SparseFloatVector.constructorLength(values));
        if (keys.length != values.length) {
            String msg = "Keys and values must be same length. Found keys.length=" + keys.length + " values.length=" + values.length;
            throw new IllegalArgumentException(msg);
        }
        for (int i = 1; i < keys.length; ++i) {
            if (keys[i - 1] < keys[i]) continue;
            String msg = "Keys must be in strictly ascending order. Found keys[" + (i - 1) + "]=" + keys[i - 1] + " keys[" + i + "]=" + keys[i];
            throw new IllegalArgumentException(msg);
        }
        if (keys.length > 0 && keys[keys.length - 1] >= numDimensions) {
            String msg = "Keys must be less than number of dimensions. Found numDimensions=" + numDimensions + " keys[" + (keys.length - 1) + "]=" + keys[keys.length - 1];
            throw new IllegalArgumentException(msg);
        }
    }

    static double constructorLength(float[] vs) {
        double sum = 0.0;
        for (int i = 0; i < vs.length; ++i) {
            sum += (double)(vs[i] * vs[i]);
        }
        return Math.sqrt(sum);
    }

    SparseFloatVector(int[] keys, float[] values, int numDimensions, double length) {
        if (numDimensions < 0) {
            String msg = "Dimensionality must be positive. Found numDimensions=" + numDimensions;
            throw new IllegalArgumentException(msg);
        }
        this.mKeys = keys;
        this.mValues = values;
        this.mNumDimensions = numDimensions;
        this.mLength = length;
    }

    private SparseFloatVector(Map<Integer, ? extends Number> map, int numDimensions, boolean useDims) {
        int maxFoundDimensions;
        Object[] keys = map.keySet().toArray(EMPTY_INTEGER_ARRAY);
        Arrays.sort(keys);
        int[] newKeys = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            newKeys[i] = (Integer)keys[i];
        }
        if (newKeys.length > 0 && newKeys[0] < 0) {
            String msg = "All keys must be non-negative. Found key=" + newKeys[0];
            throw new IllegalArgumentException(msg);
        }
        float[] values = new float[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = map.get(keys[i]).floatValue();
        }
        this.mKeys = newKeys;
        this.mValues = values;
        if (this.mKeys.length > 0 && this.mKeys[this.mKeys.length - 1] == Integer.MAX_VALUE) {
            String msg = "Maximum dimension is Integer.MAX_VALUE-1 Found dimension=Integer.MAX_VALUE";
            throw new IllegalArgumentException(msg);
        }
        int n = maxFoundDimensions = this.mKeys.length == 0 ? 0 : this.mKeys[this.mKeys.length - 1] + 1;
        if (useDims) {
            if (numDimensions < 0) {
                String msg = "Number of dimensions must be non-negative. Found numDimensions=" + numDimensions;
                throw new IllegalArgumentException(msg);
            }
            if (numDimensions < maxFoundDimensions) {
                String msg = "Specified number of dimensions lower than largest index. Num dimensions specified=" + numDimensions + " Largest dimension found=" + this.mKeys[this.mKeys.length - 1];
                throw new IllegalArgumentException(msg);
            }
            this.mNumDimensions = numDimensions;
        } else {
            this.mNumDimensions = maxFoundDimensions;
        }
        this.mLength = SparseFloatVector.computeLength(values);
    }

    @Override
    public int numDimensions() {
        return this.mNumDimensions;
    }

    @Override
    public int[] nonZeroDimensions() {
        return this.mKeys;
    }

    @Override
    public void increment(double scale, Vector v) {
        String msg = "Can not set values in sparse float vectors.";
        throw new UnsupportedOperationException(msg);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mValues.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(this.mKeys[i] + "=" + this.mValues[i]);
        }
        return sb.toString();
    }

    @Override
    public double value(int dimension) {
        if (dimension < 0 || dimension >= this.mNumDimensions) {
            String msg = "Dimension out of range. num dimensions in vector=" + this.mNumDimensions + " found dimension=" + dimension;
            throw new IndexOutOfBoundsException(msg);
        }
        int index = Arrays.binarySearch(this.mKeys, dimension);
        return index < 0 ? 0.0 : (double)this.mValues[index];
    }

    @Override
    public double length() {
        return this.mLength;
    }

    static double computeLength(float[] vals) {
        double sum = 0.0;
        for (int i = 0; i < vals.length; ++i) {
            double val = vals[i];
            sum += val * val;
        }
        return Math.sqrt(sum);
    }

    @Override
    public Vector add(Vector v) {
        if (!(v instanceof SparseFloatVector)) {
            return Matrices.add(this, v);
        }
        this.verifyMatchingDimensions(v);
        SparseFloatVector spv = (SparseFloatVector)v;
        int[] keys1 = this.mKeys;
        int[] keys2 = spv.mKeys;
        int numMatching = 0;
        int index1 = 0;
        int index2 = 0;
        while (index1 < keys1.length && index2 < keys2.length) {
            ++numMatching;
            int comp = keys1[index1] - keys2[index2];
            if (comp == 0) {
                ++index1;
                ++index2;
                continue;
            }
            if (comp < 0) {
                ++index1;
                continue;
            }
            ++index2;
        }
        while (index1 < keys1.length) {
            ++numMatching;
            ++index1;
        }
        while (index2 < keys2.length) {
            ++numMatching;
            ++index2;
        }
        float[] vals1 = this.mValues;
        float[] vals2 = spv.mValues;
        int[] resultKeys = new int[numMatching];
        float[] resultVals = new float[numMatching];
        int resultIndex = 0;
        index1 = 0;
        index2 = 0;
        while (index1 < keys1.length && index2 < keys2.length) {
            int comp = keys1[index1] - keys2[index2];
            if (comp == 0) {
                resultKeys[resultIndex] = index1;
                resultVals[resultIndex] = vals1[index1] + vals2[index2];
                ++index1;
                ++index2;
                ++resultIndex;
                continue;
            }
            if (comp < 0) {
                resultKeys[resultIndex] = index1;
                resultVals[resultIndex] = vals1[index1];
                ++index1;
                ++resultIndex;
                continue;
            }
            resultKeys[resultIndex] = index2;
            resultVals[resultIndex] = vals2[index2];
            ++index2;
            ++resultIndex;
        }
        while (index1 < keys1.length) {
            resultKeys[resultIndex] = index1;
            resultVals[resultIndex] = vals1[index1];
            ++index1;
            ++resultIndex;
        }
        while (index2 < keys2.length) {
            resultKeys[resultIndex] = index2;
            resultVals[resultIndex] = vals2[index2];
            ++index2;
            ++resultIndex;
        }
        double lengthSquared = 0.0;
        for (int i = 0; i < resultVals.length; ++i) {
            lengthSquared += (double)(resultVals[i] * resultVals[i]);
        }
        double length = Math.sqrt(lengthSquared);
        return new SparseFloatVector(resultKeys, resultVals, this.numDimensions(), length);
    }

    @Override
    public double dotProduct(Vector v) {
        this.verifyMatchingDimensions(v);
        if (v instanceof SparseFloatVector) {
            SparseFloatVector spv = (SparseFloatVector)v;
            int[] keys1 = this.mKeys;
            float[] vals1 = this.mValues;
            int[] keys2 = spv.mKeys;
            float[] vals2 = spv.mValues;
            double sum = 0.0;
            int index1 = 0;
            int index2 = 0;
            while (index1 < keys1.length && index2 < keys2.length) {
                int comp = keys1[index1] - keys2[index2];
                if (comp == 0) {
                    sum += (double)(vals1[index1++] * vals2[index2++]);
                    continue;
                }
                if (comp < 0) {
                    ++index1;
                    continue;
                }
                ++index2;
            }
            return sum;
        }
        double sum = 0.0;
        int[] keys1 = this.mKeys;
        float[] vals1 = this.mValues;
        for (int i = 0; i < keys1.length; ++i) {
            sum += (double)vals1[i] * v.value(keys1[i]);
        }
        return sum;
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof SparseFloatVector) {
            int i;
            SparseFloatVector thatVector = (SparseFloatVector)that;
            if (this.mKeys.length != thatVector.mKeys.length) {
                return false;
            }
            if (this.mNumDimensions != thatVector.mNumDimensions) {
                return false;
            }
            if (this.mLength != thatVector.mLength) {
                return false;
            }
            for (i = 0; i < this.mKeys.length; ++i) {
                if (this.mKeys[i] == thatVector.mKeys[i]) continue;
                return false;
            }
            for (i = 0; i < this.mValues.length; ++i) {
                if (this.mValues[i] == thatVector.mValues[i]) continue;
                return false;
            }
            return true;
        }
        if (that instanceof Vector) {
            Vector thatVector = (Vector)that;
            if (this.mNumDimensions != thatVector.numDimensions()) {
                return false;
            }
            if (this.mLength != thatVector.length()) {
                return false;
            }
            for (int i = 0; i < this.mKeys.length; ++i) {
                if ((double)this.mValues[i] == thatVector.value(this.mKeys[i])) continue;
                return false;
            }
            return true;
        }
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        int code = 1;
        for (int i = 0; i < this.mValues.length; ++i) {
            long v = Double.doubleToLongBits(this.mValues[i]);
            int valHash = (int)(v ^ v >>> 32);
            code = 31 * code + valHash;
        }
        return code;
    }

    @Override
    public double cosine(Vector v) {
        double cosine = this.dotProduct(v) / (v.length() * this.length());
        return cosine < -1.0 ? -1.0 : (cosine > 1.0 ? 1.0 : cosine);
    }

    private Object writeReplace() {
        return new Externalizer(this);
    }

    static class Externalizer
    extends AbstractExternalizable {
        static final long serialVersionUID = -7216149275959287094L;
        final SparseFloatVector mVector;

        public Externalizer() {
            this(null);
        }

        public Externalizer(SparseFloatVector vector) {
            this.mVector = vector;
        }

        public Object read(ObjectInput in) throws IOException {
            int len = in.readInt();
            int numDimensions = in.readInt();
            double length = in.readDouble();
            int[] keys = new int[len];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = in.readInt();
            }
            float[] values = new float[len];
            for (int i = 0; i < len; ++i) {
                values[i] = in.readFloat();
            }
            return new SparseFloatVector(keys, values, numDimensions, length);
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            int i;
            out.writeInt(this.mVector.mKeys.length);
            out.writeInt(this.mVector.mNumDimensions);
            out.writeDouble(this.mVector.mLength);
            for (i = 0; i < this.mVector.mKeys.length; ++i) {
                out.writeInt(this.mVector.mKeys[i]);
            }
            for (i = 0; i < this.mVector.mValues.length; ++i) {
                out.writeFloat(this.mVector.mValues[i]);
            }
        }
    }
}

