/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.io;

import com.aliasi.io.LogLevel;

public abstract class Reporter {
    private LogLevel mLevel;

    public Reporter() {
        this(LogLevel.NONE);
    }

    public Reporter(LogLevel level) {
        this.mLevel = level;
    }

    public abstract void report(LogLevel var1, String var2);

    public void trace(String msg) {
        this.report(LogLevel.TRACE, msg);
    }

    public void debug(String msg) {
        this.report(LogLevel.DEBUG, msg);
    }

    public void info(String msg) {
        this.report(LogLevel.INFO, msg);
    }

    public void warn(String msg) {
        this.report(LogLevel.WARN, msg);
    }

    public void error(String msg) {
        this.report(LogLevel.ERROR, msg);
    }

    public void fatal(String msg) {
        this.report(LogLevel.FATAL, msg);
    }

    public final synchronized LogLevel getLevel() {
        return this.mLevel;
    }

    public boolean isEnabled(LogLevel level) {
        return LogLevel.COMPARATOR.compare(level, this.getLevel()) >= 0;
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(LogLevel.TRACE);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(LogLevel.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(LogLevel.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(LogLevel.WARN);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(LogLevel.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.isEnabled(LogLevel.FATAL);
    }

    public final synchronized Reporter setLevel(LogLevel level) {
        this.mLevel = level;
        return this;
    }

    public abstract void close();
}

