/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import settings.Parameters;
import tsg.CFSG;
import tsg.parser.CKYChart;
import tsg.parser.CacheManager;
import tsg.parser.Cell;
import tsg.parser.Grammar;
import tsg.parser.RamCacheManager;
import tsg.parser.TestSet;
import util.FileUtil;
import util.PrintProgressStatic;

public class Parser
extends Thread {
    public static final String fedePar = "fedePar";
    public static final String bitPar = "bitPar";
    Grammar grammar;
    TestSet testSet;
    CacheManager cache;
    double pruningFactor;
    File flatFile;
    File outputFile;
    CFSG<? extends Number> CFGgrammar;

    public Parser(CFSG<? extends Number> CFGgrammar, File flatFile, File outputFile) {
        this.outputFile = outputFile;
        this.flatFile = flatFile;
        this.CFGgrammar = CFGgrammar;
    }

    @Override
    public void run() {
        List<String> inputSentences = FileUtil.convertFileToStringList(this.flatFile);
        this.grammar = new Grammar(this.CFGgrammar);
        this.grammar.checkRecursiveUnaryProductions();
        this.testSet = new TestSet(inputSentences, this.grammar);
        this.cache = new RamCacheManager(this.testSet);
        this.initializeStatics();
        PrintProgressStatic.start("FedePar is parsing sentence:");
        for (ArrayList<Integer> sentence : this.testSet.inputSentences) {
            System.gc();
            CKYChart chart = new CKYChart(sentence);
            String nBestDerivations = chart.outputBestNDerivation();
            FileUtil.appendReturn(nBestDerivations, this.outputFile);
            PrintProgressStatic.next();
        }
        PrintProgressStatic.end();
    }

    private void printTimeStatistics(int[] countSentenceLength, long[] timeSentenceLength) {
        FileUtil.appendReturn("\n Parsing time statistics", this.grammar.logFile);
        FileUtil.appendReturn("Length \t AvgParsingTime", this.grammar.logFile);
        int i = 0;
        while (i < countSentenceLength.length) {
            if (countSentenceLength[i] != 0) {
                float avg = (float)timeSentenceLength[i] / (float)(countSentenceLength[i] * 1000);
                FileUtil.appendReturn(i + "\t" + avg, this.grammar.logFile);
            }
            ++i;
        }
    }

    public void initializeStatics() {
        CKYChart.grammar = this.grammar;
        CKYChart.cache = this.cache;
        Cell.grammar = this.grammar;
    }

    private static void redirectOutput(Process p, File outFile, boolean printProgress) {
        try {
            String s = null;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            PrintWriter pw = FileUtil.getPrintWriter(outFile);
            int sentenceIndex = 1;
            if (printProgress) {
                PrintProgressStatic.start("Running bitpar, outputted lines:");
            }
            while ((s = stdInput.readLine()) != null) {
                pw.println(s);
                if (!printProgress || s.length() == 0 || s.startsWith("vitprob")) continue;
                PrintProgressStatic.next();
                ++sentenceIndex;
            }
            if (printProgress) {
                PrintProgressStatic.end();
            }
            p.getInputStream().close();
            p.getOutputStream().close();
            p.getErrorStream().close();
            pw.close();
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
        }
    }

    private static void printResults(int[] coveredTotal, File score, File scoreUL, File scoreCovered, File scoreCoveredUL, String resultFile) {
        String prefix = "Bracketing FMeasure";
        String scoreValue = FileUtil.getLineInFileStartingWith(score, prefix).split("=")[1].trim();
        String scoreULValue = FileUtil.getLineInFileStartingWith(scoreUL, prefix).split("=")[1].trim();
        String scoreCoveredValue = FileUtil.getLineInFileStartingWith(scoreCovered, prefix).split("=")[1].trim();
        String scoreCoveredULValue = FileUtil.getLineInFileStartingWith(scoreCoveredUL, prefix).split("=")[1].trim();
        File resultCompressed = new File(String.valueOf(Parameters.outputPath) + resultFile);
        if (resultCompressed.length() == 0L) {
            String firstLine = "covered\ttotal\tscore\tscoreUL\tscoreCovered\tscoreCoveredUL\n";
            FileUtil.appendReturn(firstLine, resultCompressed);
        }
        String results = String.valueOf(coveredTotal[0]) + "\t" + coveredTotal[1] + "\t" + scoreValue + "\t" + scoreULValue + "\t" + scoreCoveredValue + "\t" + scoreCoveredULValue;
        FileUtil.appendReturn(results, resultCompressed);
    }
}

