# Joint RAG-based Framework for Memory-aware Proactive Dialogue (MapDia) Task

This repository provides an implementation of the joint RAG-based framework introduced in the paper "Interpersonal Memory Matters: A New Task for Proactive Dialogue Utilizing Conversational History" . The framework is designed to tackle the Memory-aware Proactive Dialogue (MapDia) Task , which focuses on utilizing conversational history to generate proactive and contextually relevant dialogues.

## Overview

The project includes code for the inference process of the proposed framework, demonstrating how to combine a search module, ranker, and proactive dialogue model to generate proactive responses based on conversational history.

While the repository does not include training scripts, you can driectly download data from our Huggingface repository to conduct data for training Topic Summary Model, Topic Retrieval Model, and Memory-Aware Proactive Response Generation Model.

## Features

- Implements the inference pipeline for the MapDia task.
- Supports preprocessing of test data to extract key fields, reducing runtime overhead when running the full pipeline.

---

## Getting Started

### 1. Download Test Data

The test data required for inference should be prepared.

Download the `overall_dialogue_review/test.json` file and place it in the root directory of this project.

### 2. Preprocess Test Data

To reduce runtime overhead during inference, preprocess the test data using the `test_data.py` script:
```bash
python test_data.py
```

This script extracts the necessary fields from the raw test data and saves them in a simplified format for faster processing.

### 3. Run Inference

Once the test data is preprocessed, you can run the inference pipeline such as:
```bash
python ours.py
```

The script will generate proactive dialogue responses based on the provided conversational history.
