#!/bin/bash
#SBATCH --job-name=glue_pretrain # create a short name for your job
#SBATCH -N 1 # node count
#SBATCH --ntasks-per-node 1 # number of tasks to run per node
#SBATCH --cpus-per-task 10 # cpu-cores per task (>1 if multi-threaded tasks),--cpus-per-task
#SBATCH --gpus-per-node 8 # total gpus for job

OUTPUT_PREFIX=pretrain_hyperlora
RUN=glue_t5_large_auto_demo

torchrun --nproc_per_node=8 pretraining_glue.py \
    --seed 42 \
    --do_train \
    --do_eval \
    --predict_with_generate \
    --bf16 \
    --n_demonstrations 5 \
    --dataset_name data/hf_glue/glue \
    --hypelora_name_or_path hf_models/hyperlora-t5-large \
    --model_name_or_path hf_models/t5-large \
    --lora_path hf_models/lorahubs \
    --per_device_train_batch_size 6 \
    --per_device_eval_batch_size 16 \
    --gradient_accumulation_steps 2 \
    --learning_rate 5e-5 \
    --preprocessing_num_workers 16 \
    --generation_max_length 512 \
    --logging_strategy steps \
    --logging_steps 5 \
    --evaluation_strategy 'epoch' \
    --lr_scheduler_type 'cosine' \
    --num_train_epochs 12 \
    --warmup_ratio 0.05 \
    --max_seq_length 768 \
    --max_demo_length 2048 \
    --max_answer_length 512 \
    --val_max_answer_length 512 \
    --save_total_limit 1 \
    --load_best_model_at_end \
    --metric_for_best_model exact_match \
    --greater_is_better True \
    --save_strategy 'epoch' \
    --input_column src_texts \
    --output_column tgt_texts \
    --temperature 8 \
    --loss_beta 0.2 \
    --lora_rank 16 \
    --lora_alpha 8 \
    --lora_target_modules "['q', 'v']" \
    --lora_dropout 0.05 \
    --report_to wandb \
    --run_name ${OUTPUT_PREFIX}_${RUN} \
    --output_dir output/$OUTPUT_PREFIX/$RUN