import json
import math
import os 
import csv

"""
该文件中共4个函数，其他函数待更新...
read_json(): 读取json文件
save_json(): 保存json文件
read_csv(): 读取csv文件
save_csv(): 保存csv文件
"""


def read_json(data_file):
    """
    Introduce: 读取json文件
    Args: 
        data_file: json文件的路径，如 /usr/codes/data/xxx.json
    Retruns:
        data: 返回列表形式的数据，其中每条数据，表示一个json数据。
    Example:
        # json数据格式如下：
        # [
        #   "{key_1": "content_1", "key_2": "content_2"},
        #   "{key_1": "content_1", "key_2": "content_2"}
        # ]
        data_file = "/usr/codes/data/test.json"
        all_data = read_json(data_file)
        
        # 读取每一条json数据
        for data in all_data:
            key1_value = data["key_1"]
            # 每个json数据为一个字典，可根据字典的用法，获取每条数据中的对应值
    """
    with open(data_file, "r") as f:
        data = json.load(f)
    return data

def save_json(data_file, data):
    """
    Introduce: 将数据保存为json文件
    Args: 
        data_file: 要保存json文件的路径，如 /usr/codes/data/xxx.json
        data: 保存的数据，需要列表形式，并且每个列表中的元素为字典型，如：
              [
                  {"key_1": "content_1"},
                  {"key_2": "content_2"}
              ]
    Example:
        # 构建带保存的数据
        all_data = list()
        for i in range(n):
            single_data = {}
            single_data["key_1"] = "content_1"
            all_data.append(single_data)

        # 保存数据
        save_path = "/usr/codes/data/test.json"
        save_json(save_path, all_data)
    """
    with open(data_file, "w", encoding="utf-8") as f:
        json.dump(data, f, indent=4, ensure_ascii=False)
        print("Save data in {}".format(data_file))

def read_csv(data_path):
    """
    Introduce: 读取csv文件
    Args: 
        data_path: json文件的路径，如 /usr/codes/data/xxx.csv
    Retruns:
        data: 返回列表形式的数据，其中每条数据，表示csv中一行数据。(第一行数据为表头)
    Example:
        # csv中数据格式如下：
        # 性别 姓名 成绩
        # 男 王xx 90
        # 女 王xx 100

        data_file = "/usr/codes/data/test.json"
        all_data = read_csv(data_file)

        all_data = all_data[1:] # 表示去掉第0行，即去掉表头信息。
        
        # 读取每一条csv数据
        for data in all_data:
            sex = data[0] # 获取性别
            name = data[1] # 获取姓名
            value = data[2] # 获取成绩
    """
    data = list()
    with open(data_path, encoding="utf-8-sig") as f:
        for row in csv.reader(f, skipinitialspace=True):
            data.append(row)

    return data

def save_csv(save_path, headers, data):
    """
    Introduce: 将数据保存为csv文件
    Args: 
        save_path: 要保存csv文件的路径，如 /usr/codes/data/xxx.csv
        headers: csv文件类似excel表格，headers表示表头，如：性别、姓名、成绩，headers是一维列表型数据
        data: 保存的数据，需要二维列表形式，如：
              [
                  [男, 王xx, 90],
                  [女, 王x, 100]
              ]
    Example:
        # 首先构建表头
        headers = [性别, 姓名, 成绩]
        
        # 构建带保存的数据
        all_data = list()
        for i in range(n):
            single_data = [男, 王xx, 90]
            all_data.append(single_data)

        # 保存数据
        save_path = "/usr/codes/data/test.json"
        save_json(save_path, headers, all_data)
    """
    with open(save_path, "w", encoding="utf-8-sig") as csvfile:
        writer = csv.writer(csvfile)
        writer.writerow(headers)
        writer.writerows(data)
        print("Save data successfully in {}".format(save_path))