DEVICE=0
CACHE_DIR="./"
OUTPUT_DIR="./results/bapo_new/lr_5e-05_r64"

NUM_TRAIN_EPOCHS=1

PreferenceTypes=("academy literature business entertainment")

for PreferenceType in ${PreferenceTypes[@]}; do
    echo $PreferenceType
    CUDA_VISIBLE_DEVICES=$DEVICE python ./train_policy.py \
    --config_path ./config/train/policy_bapo.json \
    --model_name phi3-mini \
    --dataset_name dsp --preference_type $PreferenceType \
    --learning_rate 5e-05 --lr_scheduler_type cosine \
    --exp_name ${PreferenceType}_BAPO_5_0 --cache_dir $CACHE_DIR --output_dir $OUTPUT_DIR \
    --lora_r 32 --lora_alpha 64 \
    --bapo_lambda1 5 \
    --num_train_epochs $NUM_TRAIN_EPOCHS --group BAPO_5_0 --project BAPO
    
done

PreferenceTypes=("P1A P1B P2A P2B P3A P3B")

for PreferenceType in ${PreferenceTypes[@]}; do
    echo $PreferenceType
    CUDA_VISIBLE_DEVICES=$DEVICE python ./train_policy.py \
    --config_path ./config/train/policy_bapo.json \
    --model_name phi3-mini \
    --dataset_name psoups_identical --preference_type $PreferenceType \
    --learning_rate 5e-05 --lr_scheduler_type cosine \
    --exp_name ${PreferenceType}_BAPO_5_0 --cache_dir $CACHE_DIR --output_dir $OUTPUT_DIR \
    --lora_r 32 --lora_alpha 64 \
    --bapo_lambda1 5 \
    --num_train_epochs $NUM_TRAIN_EPOCHS --group BAPO_5_0 --project BAPO
    
done
