# PKAD: Pretrained Knowledge is All You Need to Detect and Mitigate Textual Backdoor Attacks

This is the official code of our paper "PKAD: Pretrained Knowledge is All You Need to Detect and Mitigate Textual Backdoor Attacks"

## Requirements

Python: 3.8.18

To install the dependencies, run

```bash
pip install -r requirements.txt
```

## Usage

### Data Preparation

Run the following command:

```bash
python poison.py configs/poison/agnews/badnets.json
```

This command will generate the poisoned dataset based on AG News dataset using BadNets attack.

### Defense Evaluation

Run the following command:

```bash
python defend.py configs/model/gemma_7b.json configs/attack/agnews/badnets.json configs/defend/pkad.json
```

This command will evaluate the defense method PKAD on the poisoned dataset generated by BadNets attack using Gemma-7b model.

## Acknowledgement

The code is based on the following repositories: [OpenBackdoor](https://github.com/thunlp/OpenBackdoor) and [Huggingface Transformers](https://github.com/huggingface/transformers).
We thank the authors for their open-source code. 

