import numpy as np
import cv2

try:
    import pygame
except ImportError:
    raise RuntimeError('cannot import pygame, make sure pygame package is installed')


class DisplayInterface:
    def __init__(self):
        self._width = 1200
        self._height = 900
        self._surface = None

        pygame.init()
        pygame.font.init()

        self._clock = pygame.time.Clock()
        self._display = pygame.display.set_mode((self._width, self._height), pygame.HWSURFACE | pygame.DOUBLEBUF)
        pygame.display.set_caption("HUD")

    def render(self, input_data):
        rgb_front = input_data['rgb_front']
        rgb_left = input_data['rgb_left']
        rgb_right = input_data['rgb_right']

        surface = np.zeros((self._height, self._width, 3), dtype=np.uint8)
        surface[:, :self._width] = rgb_front
        surface[:210, :280] = rgb_left
        surface[:210, 920:] = rgb_right
        surface = cv2.putText(surface, input_data['timenspeed'], (20, 710), cv2.FONT_HERSHEY_TRIPLEX,
                              0.75, (0, 0, 255), 1)
        surface = cv2.putText(surface, input_data['control'], (20, 740), cv2.FONT_HERSHEY_TRIPLEX,
                              0.75, (0, 0, 255), 1)
        surface = cv2.putText(surface, input_data['instruction'], (20, 800), cv2.FONT_HERSHEY_TRIPLEX,
                              0.75, (0, 0, 255), 1)
        surface = cv2.putText(surface, input_data['agent_message'], (20, 840), cv2.FONT_HERSHEY_TRIPLEX,
                              0.75, (0, 255, 0), 1)
        surface = cv2.putText(surface, 'Left  View', (60, 245), cv2.FONT_HERSHEY_TRIPLEX,
                              0.75, (255, 255, 255), 2)
        surface = cv2.putText(surface, 'Right View', (980, 245), cv2.FONT_HERSHEY_TRIPLEX,
                              0.75, (255, 255, 255), 2)
        # surface[:210, 278:282] = [139, 69, 19]
        # surface[:210, 493:497] = [139, 69, 19]
        # surface[:210, 703:707] = [139, 69, 19]
        # surface[:210, 918:922] = [139, 69, 19]
        # surface[208:212, :280] = [139, 69, 19]
        # surface[208:212, 920:1200] = [139, 69, 19]
        # surface[208:212, 495:705] = [139, 69, 19]

        self._surface = pygame.surfarray.make_surface(surface.swapaxes(0, 1))
        if self._surface is not None:
            self._display.blit(self._surface, (0, 0))

        pygame.display.flip()
        pygame.event.get()
        return surface
