prompt_len=20
prompt_config='configs/config_prompt_p20.json'
model='roberta-base'
output_root='roberta_base'
round=2
batch_size=16

export CUDA_VISIBLE_DEVICES=0

for seed in {43..43}
do
    # BiKT
    echo '================================================================================================================='
    echo '=                                                bikt                                                           ='
    echo '================================================================================================================='
    python -m torch.distributed.launch --nproc_per_node=8 --master_port=25644 --use_env train_roberta_multitask.py \
        --use_prompt \
        --prompt_config $prompt_config \
        --config ./configs/Round$round/Source/multitask.yaml  \
        --output_dir output/$output_root/round$round/p$prompt_len/seed$seed/multitask/bikt \
        --checkpoint output/$output_root/round$[round-1]/p$prompt_len/seed$seed/multitask/bikt/checkpoint_best_converted.pth \
        --multitask_train_prompt \
        --fix_word_embeddings \
        --text_encoder $model \
        --seed $seed \
        --batch_size $batch_size \
        --fix_prompt_pre_round 
    
    # BiKT wo frozen
    echo '================================================================================================================='
    echo '=                                                bikt wo frozen                                                 ='
    echo '================================================================================================================='
    python -m torch.distributed.launch --nproc_per_node=8 --master_port=25644 --use_env train_roberta_multitask.py \
        --use_prompt \
        --prompt_config $prompt_config \
        --config ./configs/Round$round/Source/multitask.yaml  \
        --output_dir output/$output_root/round$round/p$prompt_len/seed$seed/multitask/bikt_wo_frozen \
        --checkpoint output/$output_root/round$[round-1]/p$prompt_len/seed$seed/multitask/bikt/checkpoint_best_converted.pth \
        --multitask_train_prompt \
        --fix_word_embeddings \
        --text_encoder $model \
        --seed $seed \
        --batch_size $batch_size 
    
    # BiKT raw from original pretrain model
    echo '================================================================================================================='
    echo '=                                BiKT raw from original pretrain model                                          ='
    echo '================================================================================================================='
    python -m torch.distributed.launch --nproc_per_node=8 --master_port=25644 --use_env train_roberta_multitask.py \
        --use_prompt \
        --prompt_config $prompt_config \
        --config ./configs/Round$round/Source/multitask.yaml  \
        --output_dir output/$output_root/round$round/p$prompt_len/seed$seed/multitask/bikt_raw \
        --multitask_train_prompt \
        --fix_word_embeddings \
        --text_encoder $model \
        --seed $seed \
        --batch_size $batch_size 

    # BiKT no pre round
    echo '================================================================================================================='
    echo '=                                                   BiKT no pre round                                           ='
    echo '================================================================================================================='
    python -m torch.distributed.launch --nproc_per_node=8 --master_port=25644 --use_env train_roberta_multitask.py \
        --use_prompt \
        --prompt_config $prompt_config \
        --config ./configs/Round$round/Source/multitask.yaml  \
        --output_dir output/$output_root/round$round/p$prompt_len/seed$seed/multitask/bikt_no_pre_round \
        --checkpoint output/$output_root/round$[round-1]/p$prompt_len/seed$seed/multitask/bikt/checkpoint_best_converted.pth \
        --multitask_train_prompt \
        --fix_word_embeddings \
        --text_encoder $model \
        --seed $seed \
        --batch_size $batch_size \
        --pre_round_invisible 

    # BiKT without prompt for feedback
    echo '================================================================================================================='
    echo '=                                                Multitask finetuning                                           ='
    echo '================================================================================================================='
    python -m torch.distributed.launch --nproc_per_node=8 --master_port=25644 --use_env train_roberta_multitask.py \
        --config ./configs/Round$round/Source/multitask.yaml \
        --output_dir output/$output_root/round$round/p$prompt_len/seed$seed/multitask/finetuning \
        --checkpoint output/$output_root/round$[round-1]/p$prompt_len/seed$seed/multitask/finetuning/checkpoint_best_converted.pth \
        --text_encoder $model \
        --seed $seed \
        --batch_size $batch_size

    # multitask prompt tuning
    # python -m torch.distributed.launch --nproc_per_node=8 --master_port=25644 --use_env train_roberta_multitask.py \
    #     --use_prompt \
    #     --only_prompt \
    #     --prompt_config $prompt_config \
    #     --config ./configs/Source/multitask_prompt.yaml \
    #     --output_dir output/$output_root/p$prompt_len/seed$seed/multitask/prompt_tuning \
    #     --text_encoder $model \
    #     --seed $seed \
    #     --batch_size 32
done