
few_shot_encoding_template = '''\nOriginal: {Original} -> Altered: {Altered}'''

extrapolating_template_prefix = '''You are a problem solver while the problem is to extrapolate the rules based on the observed rules. 
The problem is you are given a source character and an altered character, and you are supposed to find out what is the possible rule used to change the source text to the altered character and extrapolate the possibile rules to other English characters. 
Below are some seeds rules and you are supposed to extrapolate based on it:'''

mapping_instruction_following = '''
You are a helpful assistant and you are supposed to follow the instructions that I give to you and performing the task as far as you can. Here we want to transform the source text to the altered text by following the rules given below.
Problem Description
------
You will be given a set of rules that maps a English character to another character. You are supposed to follow the rules and transform the source text to the altered text.

Response Instruction 
------
Your final answer to this problem which should contain the following information:
1. The text that is mapped.

Response Format 
------
Following the Response Instruction, the format should be:
Result:
Altered: MappedText
The above MappedText is just a variable which is the text that is mapped from the original text. Replacing it with the text that is mapped.
'''

mapping_results_inducting = '''
You are a inductive reasoner and you can induct rules from examples correctly. You are given pairs of source text and altered text, and you are supposed to find out the rules that maps each English character to another English character. 

Problem Description
------
You are given a set of pairs of source text and altered text, you are supposed to find out the rules that maps each English character in the source text to the corresponding altered text. You should ingore the non-English character like space, numbers, question mark, etc. You should also ingore the case of the English character, which means you should treat the uppercase and lowercase as the same character.


Response Instruction
------
Your final answer to this problem should contain the following information:
1.The rules that are used to map each English character to another English character.
2.Do not produce redundant rules, which means if there are two rules that maps the same character to the same character, you should only response one of them.
3.The mapping character should be uppercase English character.

Response Format
------
Rules:
Original: x1 -> Altered: y1
Original: x2 -> Altered: y2
......
Above Sides x1, y1, x2 and y2 are just variables, replacing them with English characters, which should be only uppercase English character.
'''

mapping_results_validating = '''
You are an accurate error-checking assistant and you can identify errors correctly, you have access to several pre-defined rules that maps each English character to another English character and you are given a Original and Altered text pair. The Altered string is obtained by mapping each English character in the Original text one by one using those pre-defined rules. However, the mapping for each character may not be correct. You are supposed to find out whether the mapping from Original to the Altered text is correct or not, if not, locate the position of error character and rectify it.

Problem Description
------
You are giving a set of rules that maps each English character to another English character. You are supposed to check whether we can get the altered text from the original text using those rules if not where is wrong and locate the error.

Rules 
------
Below are the rules that map each English character to another English character, those rules works for both Uppercase and Lowercase:
{Rules}
 
Notice:Those rules only work for the English alphabet and if encounter non-English character like space, numbers, question mark, etc, you don't have to check it.

Response Instruction 
------
Your final answer to this problem which should contain the following information:
1. Whether we can obtain the altered text by following the rules given above. 
2. If the result is invalid, response with the rectified Altered result.

Response Format 
------
Following the Response Instruction, the format should be:
Validation Result:
Valid or Invalid
Rectified Results:
1.If the result is Valid, you response with There is not character to correct.
2.If the result is Invalid, you response the rectified altered text in following format.
Altered: RectifiedAlteredText
The above RectifiedAlteredText is just a variable, you should replace it with the actual rectified altered text.
'''

mapping_results_validating_scrathpad = '''
'''


mapping_results_error_correction = '''
You are a error rectifier. you have access to several pre-defined rules that maps each English character to another English character and you are given a Original and Altered text pair. The Altered string is obtained by mapping each English character in the Original text one by one using those pre-defined rules. 

Problem Description
------
Some problems may happened to those rules due to some unexpected reasons, some of those rules may be disturbed so the rules may not be correct any more. You are supposed to rectify those rules by observing the Original and Altered string pair, where the Altered string pair is mapped by previou undisturbed correct rules before. By checking rules and the Original and Altered string pair, you can identify where the given rules are correct or not.

Response Instruction 
------
Your final answer to this problem which should contain the following information:
1. Are given rules correct or not. 
2. If not correct, what is/are the rectified one/ones. 
3. If there are examples provided, you should try to follow the procedure that how examples solve the problem.

Response Format 
------
Correct Rules or Not:
Yes or No
Rectified Rules:
1. If the result is Yes, you should response with there is no rule to correct.
2. If the result is No, you should response the rectified rule/rules.
For example: Original: x1 -> Altered: y1
Here x1 and y1 are just variables that represents English characters and does not have actual meanings, you should replace it with actual English characters based on your analyse.
'''

mapping_results_rules_incorporating = '''
You are a inductive reasoner. You have access to several pre-defined rules that maps each English character to another English character and you are given a Original and Altered text pair. The Altered string is obtained by mapping each English character in the Original text one by one using those pre-defined rules. 

Problem Description
------
We have derived several rules based on previous observations of the Original and Altered pairs. Now we have a new data, the problem is whether the new data can provide new rules or not. You are supposed to analyse whether the new pair can proviede additional information or not. If the new pair presents new mapping rules, you should be able to identify it and incorporate them into the rules.

Response Instruction 
------
Your final answer to this problem which should contain the following information:
1. Does the Original and Altered pair provide new information or not 
2. If it provides new information, what is the new rule that can be inducted. 
3. If there are examples provided, you should try to follow the procedure that how examples solve the problem.

Response Format 
------
New Information Contained:
Yes or No
New Rules Inducted:
1.If answers No in New Information Contained, you should response with No.
2.If answers Yes in New Information Contained, response with the new inducted rules in following format.
For example:
Original: x1 -> Altered: y1
Here x1 and y1 are just variables that represents English characters and does not have actual meanings, you should replace it with actual English characters based on your analysis.
'''

mapping_instruction = '''
Below are the character mapping rules that maps each English character to another English character, those rules works for both Uppercase and Lowercase:
{Rules}

Now try your best to map the Original text to the Altered text using above rules and Response Format:
Original: {Original}

Remember your response must follow the response format.
'''

mapping_inducting = '''  
Now try your best to induct the mapping rules from following Original and Altered pair:
Original: {Original}
Altered: {Altered}

Remember your response should follow the response format.
'''

mapping_validating = '''  
Now try your best to answer whether the question for following Original and Altered pair:
Original: {Original}
Altered: {Altered}

Remember your response should follow the response format.
'''

mapping_error_correction = '''  
Try your best to answer the question using above Response Format that whether following rules contain incorrect rules or not:
{Rules}

Following is the correct ordered list of colors:
Original: {Original}
Altered: {Altered}

Now you need to induct whether there are wrong rules existing in the given pre-defined color preference rules and your response should follow the response format.
'''

mapping_incorporating = '''  
You have access to the following rules:
{Rules}

You have access to the following Original and Altered pair:
Original: {Original}
Altered: {Altered}

Now you need to check whether we can induct new rules from the given Original and Altered pair. Remember your response should follow the response format.
'''

grouping_instruction_following = '''
You are a helpful assistant and you are supposed to follow the instructions that I give to you and performing the task as far as you can. Here we want to group different polygons into different groups based on their characteristics.

Problem Description
------
You will be given the possible attributes of different polygons with different Sides Numbers, Colors and Materials. You will also be given the grouping rules that describe what types of polygons should be grouped together. You are supposed to group those polygons into different groups based on the grouping rules.

Attributes
------
Sides Numbers: {SidesNumber}
Colors: {Colors}
Materials: {Materials}

Response Instruction 
------
Your final answer to this problem which should contain the following information:
1. The polygons that belongs to each group. 

Response Format 
------
Following the Response Instruction, the format should be:
Grouping Result:
Group 0:  Polygon x1, Polygon x2, ...
Group 1:  Polygon y1, Polygon y2, ...
...
The above format is just an example, you should replace x1, x2, y1, y2 with actual polygons based on your analyse. The order of polygons in each group does not matter.
'''

grouping_induct_template = ''' 
You are a inductive reasoner and you can induct rules from examples correctly. You are given several polygons with different attributes like Number of Sides, Colors and Materials of Polygons. Additionally, you will be given a grouping results that those polygons are classified into different groups. You are supposed to find the grouping rules.

Problem Description
------
We first let you know the possible attributes for those polygons. Each polygon is a combination of those attributes. Then we give you all the polygons that might be used for this problem. Now you have all the attributes and all the polygons, we give you the grouping results and you are supposed to find the grouping rules that can be applied to those polygons to obtain the grouping results.

Attributes
------
Sides Numbers: {SidesNumber}
Colors: {Colors}
Materials: {Materials}

Response Instruction
------
Your final answer to this problem should contain the following information:
1.The rules that are used to group those polygons.

Response Format
------
Grouping Rules:
1. Polygons with x Sides, y Color, and z should be grouped together.
......
Above Sides x, y and z are just variables, replacing them with actual number, color and materials when producing answer
'''

grouping_results_validating = '''
You are an accurate error-checking assistant and you can identify errors correctly, you have access to several pre-defined rules that illustrate the grouping rules that you can used to group different polygons into different groups. You will be given a grouping results and grouping rules and polygons. However, the grouping may not be correct. You are supposed to find out whether the grouping results is correct or not, if not, locate the error and rectify it.
Problem Description
------
You are given a set of grouping results of different polygons. You knows the grouping rules and information about all the polygons. However, the grouping results may not be correct.You are supposed to find out whether the grouping results is correct or not. If it is not correct, you should be able to locate the error and rectify it.

Attributes
------
Below are all attributes options for a polygon to have:
Sides Numbers: {SidesNumber}
Colors: {Colors}
Materials: {Materials}

Response Instruction 
------
Your final answer to this problem which should contain the following information:
1. Is the grouping result of polygons correct or not.
2. If the grouping results is not correct, give the rectified grouping result. 

Response Format 
------
Following the Response Instruction, the format should be:
Validation Result:
Correct or Incorrect
Rectified Results:
1.If the result is Correct, you response with None.
2.If the result is Invalid, you response with a new grouping result.
Group x: Polygon z_1, Polygon z_2, Polygon z_3..
Group y: Polygon n_1, Polygon n_2, Polygon n_3..
...
Above Group x, y, z_x and n_x are just variables, replacing it with actual group name when producing answer
'''

grouping_results_error_correction = '''
You are a error rectifier. you have access to several pre-defined rules that hat illustrate the grouping rules that you can used to group different polygons into different groups. You will be given the grouping results and grouping rules and polygons. However, the grouping rules may not be correct. You are supposed to find out whether we can obtain the grouping results following the grouping rules, if not, locate the error of rules and rectify it. 

Problem Description
------
Some problems may happened to grouping rules due to some unexpected reasons, some of those rules may be disturbed so the rules may not be fully correct. You are supposed to rectify those rules by observing the grouping results of polygons. By checking rules and the grouping results, you can identify whether the given rules are correct or not.

Attributes
------
Below are all attributes options for a polygon to have:
Sides Numbers: {SidesNumber}
Colors: {Colors}
Materials: {Materials}

Response Instruction 
------
Your final answer to this problem which should contain the following information:
1. Are given rules correct or not. 
2. If not correct, what is/are the rectified one/ones. 

Response Format 
------
Following the Response Instruction, the response format is following:
Correct Rules or Not:
Yes or No
Rectified Rules:
1. If the result is Yes, you should response with "There is no rule to correct".
2. If the result is No, you should response the rectified rule/rules in the following format: 
1. The wrong rule: x1 Sides, y1 Color, and z1 -> The correct rule: x2 Sides, y2 Color, and z2
....
The above x1 and x2, y1 and y2, z1 and z2 are just variables. You should replace it with actual number of side, color and material. Remember the The wrong rule and the correct ruel should be separated by "->" and are in one line.
Especially, x1, y1, z1 are the variables for wrong sides, color and material and x2, y2, z2 are the variables for correct sides, color and material.
'''

grouping_results_rules_incorporating = '''
You are a inductive reasoner. you have access to several pre-defined rules that hat illustrate the grouping rules that groups different polygons into different groups. You will be given the grouping results, grouping rules, polygons and available attributes of polygons. However, the grouping rules may not be complete. You are supposed to find out whether we can obtain new grouping rule/rules from the grouping results, if yes, discover new rules. 

Problem Description
------
We have derived several rules based on previous observations of the grouping results of polygons. Now we have a new data, the problem is whether the new data can provide new rules or not. You are supposed to analyse whether the new grouping results can provide additional information or not. If the new grouping results presents new grouping rules, you should be able to identify it and incorporate them into the current rules.

Attributes
------
Below are all attributes options for a polygon to have:
Sides Numbers: {SidesNumber}
Colors: {Colors}
Materials: {Materials}

Response Instruction 
------
Your final answer to this problem which should contain the following information:
1. Does the grouping results provide new information or not?
2. If given grouping results provides new rule/rules, what is/are the new rule/rules that can be inducted from the grouping results? 

Response Format 
------
Following the Response Instruction, your response should follow following format:
New Rules or Not:
Yes or No
Added Rules:
1. If the above result is No, you should response with "There is no rule to add" after Added Rules.
2. If the above result is Yes, you should response the added rule/rules after Added Rules in the following format:
1. Polygons with x Sides, y Color, and z should be grouped together.
......
Above x, y and z are just variables, replacing them with actual number, color and materials when producing answers.
'''

grouping_instruction = '''
Below are the grouping rules that describe what types of polygons should be grouped together:
{Rules}

Now try your best to use those grouping rules to group following polygons, your response should follow the Response Format.
{Polygons}
'''

grouping_incorporating = '''
Below are the polygons for this example:
{Polygons}

Below are the rules that are used to group different polygons into different groups which may be incomplete:
{Rules}

Below are the grouping results for the above polygons with those attributes:
{GroupingResult}

Now you need to check whether the grouping results provide new rules or not  and your response must follow the response format. 
'''

grouping_error_correction = '''
Below are the polygons for this example:
{Polygons}

Below are the rules that are used to group different polygons into different groups which may be incorrect:
{Rules}

These are the correct grouping results for the above polygons with those attributes:
{GroupingResult}

Now you need to check whether the grouping rules are correct or not if not give the rectified results and your response must follow the response format. 
'''

grouping_validating = '''
You have access to following polygons:
{Polygons}

Below are the rules that are used to group different polygons into different groups:
{Rules}

These are the grouping results for the above polygons with those attributes following above rules:
{GroupingResult}

Now you need to check whether the grouping results are correct or not based on given polygons and rules, if not, give the rectified results and your response must follow the response format. 
'''

grouping_questions = '''
You have access to following polygons:
{Polygons}

These are the grouping results for the above polygons with those attributes:
{GroupingResult}

Now you need to induct the grouping rules following above Problem Description, Response Instruction and Response Format. 
'''

ordering_instruction_following = '''
You are a helpful assistant and you are supposed to follow the instructions that I give to you and performing the task as far as you can. Here we want to sort the given color lists that follows certain color preferences.

Problem Description
------
You will be given a set of rules that presents the color preferences. Your will be given an unordered color list and you should output the ordered list following the color preferences.

Color Set
------
You have access to the following colors:
{colors}

Response Instruction 
------
Your final answer to this problem should contain the following information:
1. The resortd color list that is based on the given color preferences and unordered color list.

Response Format 
------
Following the Response Instruction, the format should be:
Sorted Color List:
1. Color_1.
2. Color_2.
3. Color_3.
...
The above Color_x is just a variable here that does not hold any actual meaning. You should replace Color_x with actual colors from the given data.
'''

ordering_induct_template = '''
You are a inductive reasoner and you can induct rules from examples correctly. You are given a ordering result that the elements of the ordered result are different colors. You are supposed to find out the preference of the different colors which means what color has the highest rank.

Problem Description
------
You are given a ordered list where instead of ordering the numbers, the element of ordered list are colors. Though analyzeing the unordered list and the ordered list, you are required to find out that the rank of different colors.

Color Set
------
You have access to the following colors:
{colors}

Response Instruction
------
Your final answer to this problem should contain the following information:
1.The analyzed ranks of different colors.

Response Format
------
Color Ranking:
1. Rank 1 Color_1
2. Rank 2 Color_2
3. Rank 3 Color_3
4. Rank 4 Color_4
......
Color_x above is just a variable here that does not hold any actual meaning. You should replace Color_x with actual colors from the given data.

'''

ordering_results_validating = '''
You are an accurate error-checking assistant and you can identify errors correctly. You have access to pre-defined ordering rules that shows the preference of colors and you are given a ordering results based on those pre-defined ordering rules. However, the grouping results may not be correct. You are supposed to find out whether the given ordering results are correct or not. If not, you should be able to identify the errors and correct them.

Problem Description
------
You are given pre-defined ordering preferences that shows the preference of colors and you are given a ordering results based on those pre-defined ordering rules. However, the grouping results may not be correct. You are supposed to find out whether the given ordering results are correct or not. If not, you should be able to identify the errors and correct them.

Color Set
------
You have access to the following colors:
{colors}

Response Instruction
------
Your final answer to this problem should contain the following information:
1.Whether the given ordering results are correct or not.
2.If not, what is/are the error/errors and the rectified one/ones.

Response Format
------
Correct Results or Not:
Yes or No
Rectified Results:
1. If the result is Yes, you should response with "There is no error to correct".
2. If the result is No, you should response the rectified pair of colors in the following format, which means the color that has the wrong priority (left hand side) should be replaced with the right hand side color.
For example:
The correct ordering results are:
Wrong Priority Color: Color_x -> Rectified Priority Color: Color_y
......
Color_x and Color_y above is just a variable here that does not hold any actual meaning. You should replace Color_x with actual colors from the given data.
'''

ordering_results_error_correction='''
You are an accurate error-checking assistant and you can identify errors correctly. You have access to pre-defined ordering rules that shows the preference of colors and you are given a ordering results based on those pre-defined ordering rules. However, the color preference rules may not be correct. You are supposed to find out whether the given preference rules are correct or not. If not, you should be able to identify the errors and correct them.

Problem Description
------
You have access to pre-defined ordering rules that shows the preference of colors and you are given a ordering results based on those pre-defined ordering rules. However, the color preference rules may not be correct. You are supposed to find out whether the given preference rules are correct or not. If not, you should be able to identify the errors and correct them.

Color Set
------
You have access to the following colors:
{colors}

Response Instruction
------
Your final answer to this problem should contain the following information:
1.Whether the given ordering rules are correct or not.
2.If not, what is/are the error/errors and the rectified one/ones.

Response Format
------
Correct Rules or Not:
Yes or No
Rectified Rules:
1. If the result is Yes, you should response with "There is no error to correct" following the Rectified Rules.
2. If the result is No, you should response the rectified rule/rules only of the error rules in the following format. 
Rank a : Color_x.
Rank b : Color_y.
Rank c : Color_z.
......
Rank n : Color_m.
Color_x, Color_y, Color_z, Color_m above are just a variable here that does not hold any actual meaning. Additionally, not just the Color_x, Color_y, Color_z, Color_m presented in the format are the only errors but there are possibly more or less errors in the given color reference which you need to figure out how many errors in the given color preference and answer based on the given format. You should replace them with actual colors from the given color set.
The a, b, c, n after the RANK represents the rectified rank of the color. You should replace them with actual correct rank of the color.

'''

ordering_results_rules_incorporating='''
You are an accurate error-checking assistant and you can identify errors correctly. You have access to pre-defined ordering rules that shows the preference of colors and you are given a ordering results based on those pre-defined ordering rules. However, the color preference rules may not be complete and cannot fully describe the data. You are supposed to find out whether the given new results can provide new information or not. If yes, you should be able to identify what new color preferences we can infer from the data.

Problem Description
------
You have access to pre-defined ordering rules that shows the preference of colors and you are given a ordering results based on those pre-defined ordering rules. However, the color preference rules may not be complete and cannot fully describe the data. You are supposed to find out whether the given new results can provide new information or not. If yes, you should be able to identify what new color preferences we can infer from the data. You should be able to incorporate the new information into the existing color preference rules and response with the new color preference rules with its rank in the new incorporated rules.

Color Set
------
You have access to the following colors:
{colors}

Response Instruction
------
Your final answer to this problem should contain the following information:
1.Whether the given ordering results provide new information or not.
2.If yes, what is/are the new rule/rules we can induct from the results and their rank. Additionally, the rank of the new rule/rules should be in the new incorporated color preference rather than the original given color preference.

Response Format
------
New Rules or Not:
Yes or No
New Inducted::
1. If the result is Yes, you should response with the new rule/rules that we can induct from the results.
2. If the result is No, you should response with "There is no new information".
For example:
New Inducted:
1. Rank x : Color_a.
2. Rank y : Color_b.
3. Rank z : Color_c.
......
Color_a, Color_b and Color_c above are just a variable here that does not hold any actual meaning. You should replace them with actual colors from the given data.
The x, y, z after the Rank represents the rank of the color. You should replace them with the correct rank of the new inducted color.
'''

ordering_instruction = '''
You have access to the following color preference rules that describes the correct color preference rank that you can use to sort the following unordered color list, but do not output the color preference rank directly, you should sort the following color list according to following color preference rules:
{color_preference}

Now try your best to sort the following unordered color list according to the given color preference rules above and your response should follow the response format, don't just copy the color preference rank above but try to sort the following color list according to the given color preference rules above:
{UnOrderedLists}
'''

ordering_questions = '''
Following is the ordered list of colors:

{OrderedLists}

Now you need to induct the rank of different colors using above problem description, color set and response instruction and your response should follow the response format:
'''

ordering_incorporating = '''
You have access to the following original color preference rules that may be incomplete:

{color_preference}

Following is the ordered list of colors that may provide new information:

{OrderedLists}

Now you need to induct whether we can induct new rule/rules from the given results and your response should follow the response format. Remember that the new rule/rules should be in the new incorporated color preference rather than the original given color preference.
'''

ordering_error_correction = '''
You have access to the following color preference rules that may contain incorrect rules:

{color_preference}

Following is the correct ordered list of colors:

{OrderedLists}

Now you need to induct whether there are wrong rules existing in the given pre-defined color preference rules and your response should follow the response format.
'''

ordering_validating = '''
You have access to the following color preference rules that describes the correct color preference:

{color_preference}

You have the following Ordered Color results that may not be correct:

{OrderedLists}

Now you need to induct whether the ordered colors follows the color preference rules or not and your response should follow the response format.
'''

grouping_template_dict = {
    "instruction_pair": [grouping_instruction_following, grouping_instruction],
    "inducting_pair": [grouping_induct_template, grouping_questions],
    "validating_pair": [grouping_results_validating, grouping_validating],
    "error_correction_pair": [grouping_results_error_correction, grouping_error_correction],
    "incorporating_pair": [grouping_results_rules_incorporating, grouping_incorporating]
}

ordering_template_dict = {
    "instruction_pair": [ordering_instruction_following, ordering_instruction],
    "inducting_pair": [ordering_induct_template, ordering_questions],
    "validating_pair": [ordering_results_validating, ordering_validating],
    "error_correction_pair": [ordering_results_error_correction, ordering_error_correction],
    "incorporating_pair": [ordering_results_rules_incorporating, ordering_incorporating]
}

mapping_template_dict = {
    "instruction_pair": [mapping_instruction_following, mapping_instruction],
    "inducting_pair": [mapping_results_inducting, mapping_inducting],
    "validating_pair": [mapping_results_validating, mapping_validating],
    "error_correction_pair": [mapping_results_error_correction, mapping_error_correction],
    "incorporating_pair": [mapping_results_rules_incorporating, mapping_incorporating]
}

