from PIL import Image
import numpy as np
import base64
from io import BytesIO
import json
from paddleocr import PaddleOCR


def image_to_base64(img):
    output_buffer = BytesIO()
    img.save(output_buffer, format='png')
    byte_data = output_buffer.getvalue()
    base64_str = base64.b64encode(byte_data)
    base64_str = base64_str.decode('utf-8')
    return base64_str

def default_dump(obj):
    """Convert numpy classes to JSON serializable objects."""
    if isinstance(obj, (np.integer, np.floating, np.bool_)):
        return obj.item()
    elif isinstance(obj, np.ndarray):
        return obj.tolist()
    else:
        return obj

ocr_model_path='/disk1/liwenbo/models/ocr_models'
img = Image.open('example.png')
ocr_model = ocr_model = PaddleOCR(
        use_angle_cls=True,
        lang='ch',
        use_gpu=False,
        det_model_dir=f"{ocr_model_path}/ch_PP-OCRv4_det_server_infer",
        rec_model_dir=f"{ocr_model_path}/ch_PP-OCRv4_rec_server_infer",
        cls_model_dir=f"{ocr_model_path}/ch_ppocr_mobile_v2.0_cls_slim_infer",
        show_log=False,
    )
ret = ocr_model.ocr(np.array(img))[0]
img_str = image_to_base64(img) 
print(img_str)
with open('data/all_data/part', 'w') as f:
    f.write('example_0' + '\t' + 'raw' + json.dumps({
        'caption': 'Cute teddy bear holding a sign with text "Happy Days" in red.',
        'ocr_info': ret}, default=default_dump) + '\t'
        + '1024X1024' + '\t' + 'raw_path' + '\t' + img_str + '\n')