theory question_88_10
imports Main

begin

typedecl entity
typedecl event

consts
  Balance :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Mass :: "entity ⇒ bool"
  Use :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  DirectlyDetermines :: "event ⇒ bool"

theorem hypothesis:
  assumes asm: "Balance x ∧ Object y ∧ Mass z ∧ Use e ∧ Agent e w ∧ Patient e x"
  (* Hypothesis: A balance is used to determine the mass of an object. *)
  shows "DirectlyDetermines e ∧ Patient e z ∧ HasProperty z y"
proof -
  from asm have "Determine e ∧ Patient e z ∧ HasProperty z y" using explanation_1 by blast
  then show ?thesis by simp
qed

axiomatization where
  explanation_1: "∀x y z e. Balance x ∧ Object y ∧ Mass z ∧ Use e ∧ Agent e w ∧ Patient e x ⟶ Determine e ∧ Patient e z ∧ HasProperty z y"

end
