theory question_90_6

imports Main

begin

typedecl entity
typedecl event

consts
  Workers :: "entity ⇒ bool"
  bentOver :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  bentPosition :: "entity ⇒ bool"
  Action :: "event ⇒ bool"
  Grass :: "entity ⇒ bool"
  pulling :: "event ⇒ bool"
  Three :: "entity ⇒ bool"

(* Explanation: Three workers bent over pulling grass. *)
axiomatization where
  explanation: "∀x y z e e'. Workers x ∧ Three y ∧ bentOver e ∧ Agent e x ∧ Grass z ∧ pulling e' ∧ Agent e' x ∧ Patient e' z"

theorem hypothesis:
  (* Premise: Three workers bent over pulling grass. *)
  assumes asm: "Workers x ∧ Three y ∧ bentOver e ∧ Agent e x ∧ Grass z ∧ pulling e' ∧ Agent e' x ∧ Patient e' z"
  (* Hypothesis: Three workers bent over. *)
  shows "∃x y z. Workers x ∧ Three y ∧ bentOver e ∧ Agent e x ∧ bentPosition z"
proof -
  from asm have "Workers x" "bentOver e" "Agent e x" "Grass z" "pulling e'" "Patient e' z" by blast
  then have "∃v. Workers v ∧ bentOver e ∧ Agent e v ∧ bentPosition z" using explanation_2 by blast
  then show ?thesis using asm by blast
qed

end
