theory question_12_8

imports Main

begin

typedecl entity
typedecl event

consts
  FootballGame :: "entity ⇒ bool"
  Game :: "entity ⇒ bool"
  Team :: "entity ⇒ bool"
  Opposing :: "entity ⇒ entity ⇒ bool"
  Playing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  FootballPlayer :: "entity ⇒ bool"
  TeamMember :: "entity ⇒ entity ⇒ bool"
  Football :: "entity ⇒ bool"
  BelongsTo :: "entity ⇒ entity ⇒ bool"
  SameTeam :: "entity ⇒ entity ⇒ bool"
  Chasing :: "event ⇒ bool"
  t1 :: "entity"
  t2 :: "entity"

(* Explanation: A football player is playing football in a game and chasing an opposing team's player. *)
axiomatization where
  explanation: "∀x y z e1 e2. FootballPlayer x ∧ Football y ∧ Game z ∧ Team x t1 ∧ Team y t2 ∧ Opposing t1 t2 ∧ Playing e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Chasing e2 ∧ Agent e2 x ∧ Patient e2 y"

theorem hypothesis:
  (* Premise: None *)
  assumes asm: "true"
  (* Hypothesis: A football playing chasing the opposing teams player in a game. *)
  shows "∃x y z e1 e2. FootballPlayer x ∧ Football y ∧ Game z ∧ Team x t1 ∧ Team y t2 ∧ Opposing t1 t2 ∧ Playing e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Chasing e2 ∧ Agent e2 x ∧ Patient e2 y"
proof -
  from asm have "true" by blast
  then have "∃x y z e1 e2. FootballPlayer x ∧ Football y ∧ Game z ∧ Team x t1 ∧ Team y t2 ∧ Opposing t1 t2 ∧ Playing e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Chasing e2 ∧ Agent e2 x ∧ Patient e2 y" using explanation by blast
  then show ?thesis by blast
qed

end
