theory question_65_1
imports Main

begin

typedecl entity
typedecl event

consts
  Electricity :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  In_ :: "entity ⇒ entity ⇒ bool"
  Component :: "entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  ComesOn :: "event ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Closed :: "event ⇒ bool"
  Switch :: "entity ⇒ bool"

(* Explanation 1: In a simple series circuit, when electricity flows, it flows to all components in the circuit. *)
axiomatization where
  explanation_1: "∀x e c. Electricity x ∧ SimpleSeriesCircuit c ∧ Flows e ∧ Agent e x ∧ In_ x c ⟶ (∀z. Component z ∧ In_ z c ⟶ Patient e z)"

(* Explanation 2: When electricity flows to a light bulb, the light bulb will turn on; come on. *)
axiomatization where
  explanation_2: "∀x y e1 e2 e3. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (TurnOn e2 ∧ Agent e2 y) ∧ ComesOn e3 ∧ Agent e3 y"

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit s ∧ Closed e ∧ Agent e x ∧ In_ x s"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃y e1 e2. Electricity y ∧ LightBulb z ∧ Flows e1 ∧ Agent e1 y ∧ Patient e1 z ∧ ComesOn e2 ∧ Agent e2 z"
proof -
  {
    assume "Switch x ∧ SimpleSeriesCircuit s ∧ Closed e ∧ Agent e x ∧ In_ x s"
    then obtain y where "Electricity y ∧ In_ y s" using explanation_1 by blast
    then have "Electricity y ∧ LightBulb z ∧ Flows e1 ∧ Agent e1 y ∧ Patient e1 z ∧ ComesOn e2 ∧ Agent e2 z" using explanation_2 by blast
  }
  then show ?thesis by blast
qed

end
