theory question_98_0

imports Main

begin
typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  YoungMan :: "entity ⇒ bool"
  Goggles :: "entity ⇒ bool"
  Water :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Splashing :: "event ⇒ bool"
  Everywhere :: "entity ⇒ bool"

(* Explanation 1: There is both a man jumping out of a pool. *)
axiomatization where
  explanation_1: "∃x y e. Man x ∧ Pool y ∧ Jumping e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
  assumes asm: "YoungMan x ∧ Goggles z ∧ Pool y ∧ Water w ∧ Wearing x z ∧ Jumping e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Splashing e2 ∧ Agent e2 x ∧ Patient e2 w ∧ Everywhere w"
  (* Hypothesis: Man jumping out of a pool. *)
  shows "∃x y e. Man x ∧ Pool y ∧ Jumping e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "YoungMan x ∧ Pool y ∧ Jumping e1 ∧ Agent e1 x ∧ Patient e1 y" by blast
  then have "Man x ∧ Pool y ∧ Jumping e1 ∧ Agent e1 x ∧ Patient e1 y" using asm by blast
  then show ?thesis by blast
qed

end
