theory question_36_4
imports Main

begin
typedecl entity
typedecl event
typedecl season

consts
  BusyCityStreet :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Many :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  SameTime :: "entity ⇒ entity ⇒ bool"
  Walking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Down :: "event ⇒ entity ⇒ entity ⇒ bool"
  Winter :: "season ⇒ bool"
  In :: "event ⇒ season ⇒ bool"

(* Explanation 1: A busy city street is a street that has many people on it at the same time. *)
axiomatization where
  explanation_1: "∀x. BusyCityStreet x ⟷ (Street x ∧ ∃y. People y ∧ Many y ∧ On y x ∧ SameTime y x)"

(* Explanation 2: People who are walking are on a street. *)
axiomatization where
  explanation_2: "∀x y e. People x ∧ Walking e ∧ Agent e x ⟶ ∃z. Street z ∧ On x z"

theorem hypothesis:
  (* Premise: People walking down a busy city street in the winter. *)
  assumes asm: "People x ∧ BusyCityStreet y ∧ Winter z ∧ Walking e ∧ Agent e x ∧ Down e x y ∧ On x y ∧ In e z"
  (* Hypothesis: The street has a lot of people. *)
  shows "∃x y. Street x ∧ People y ∧ Many y ∧ On y x"
proof -
  from asm have "BusyCityStreet y" by blast
  then have "Street y ∧ ∃x. People x ∧ Many x ∧ On x y ∧ SameTime x y" using explanation_1 by blast
  then obtain x where "People x ∧ Many x ∧ On x y ∧ SameTime x y" by blast
  show ?thesis using asm `Street y` `People x` `Many x` `On x y` by blast
qed

end
