theory question_85_1

imports Main

begin
typedecl entity

consts
  Vendor :: "entity ⇒ bool"
  Seller :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  FlowerCart :: "entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A vendor is a seller. *)
axiomatization where
  explanation_1: "∀x. Vendor x ⟶ Seller x"

(* Explanation 2: A vendor is on the sidewalk. *)
axiomatization where
  explanation_2: "∃x y. Vendor x ∧ Sidewalk y ∧ On x y"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "Vendor x ∧ FlowerCart y ∧ Sidewalk z ∧ On x z ∧ Has x y"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x y. FlowerSeller x ∧ Sidewalk y ∧ On x y"
proof -
  from asm have "Vendor x ∧ Sidewalk z ∧ On x z" by blast
  then have "Seller x ∧ Sidewalk z ∧ On x z" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
