theory question_54_1
imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Tennis :: "entity ⇒ bool"
  Playing :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  RedAndBlack :: "entity ⇒ bool"
  TennisBall :: "entity ⇒ bool"
  AboutTo :: "entity ⇒ bool"
  Strike :: "event ⇒ entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Striking a tennis ball is an action of playing tennis. *)
axiomatization where
  explanation_1: "∀x y e. TennisBall x ∧ Action y ∧ Strike e ∧ Agent e x ⟶ Playing e y"

theorem hypothesis:
  (* Premise: A man in red and black about to strike a tennis ball. *)
  assumes asm: "Man x ∧ RedAndBlack x ∧ TennisBall y ∧ AboutTo z ∧ Strike e y ∧ Agent e x ∧ Patient e y ∧ In z e"
  (* Hypothesis: A man is playing tennis. *)
  shows "∃x y e. Man x ∧ Tennis y ∧ Playing e y ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Man x ∧ TennisBall y ∧ Strike e y ∧ Agent e x" by blast
  then have "Man x ∧ Tennis y ∧ Playing e y ∧ Agent e x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
